import jcsp.lang.*;

//{{{ class CheckPrimes implements CSProcess
class CheckPrimes implements CSProcess {

  //{{{ private limit, in
  private final ChannelOutputInt out;
  //}}} 
  
  //{{{ public CheckPrimes
  public CheckPrimes (final ChannelOutputInt out) {
    this.out = out;
  }
  //}}} 

  //{{{ private boolean isPrime
  private boolean isPrime (int n) {     // assume : n is odd and > 3
    int i = 3;
    while (((i*i) < n) && ((n%i) != 0)) {
      i += 2;
    }
    return (n%i) != 0;
  }
  //}}} 

  //{{{ public void run
  public void run () {
    // out.write (2);
    out.write (3);
    int n = 5;
    while (n < 1000000) {
      if (isPrime (n)) out.write (n);
      n += 2;
    }
  }
  //}}} 
  
}
//}}} 
