import jcsp.lang.*;
import java.util.*;

public class Worker implements CSProcess {

  private final int id;
  private final long seed;
  private final int maxWork;
  private final Bucket bucket;

  public Worker (int id, long seed, int maxWork, Bucket bucket) {
    this.id = id;
    this.seed = seed;
    this.maxWork = maxWork;
    this.bucket = bucket;
  }

  public void run () {

    final Random random = new Random (seed);        // each process gets a different seed

    final CSTimer tim = new CSTimer ();
    final int second = 1000;                        // JCSP timer units are milliseconds

    final String working = "\t... Worker " + id + " working ...";
    final String falling = "\t\t\t     ... Worker " + id + " falling ...";
    final String flushed = "\t\t\t\t\t\t  ... Worker " + id + " flushed ...";

    while (true) {
      System.out.println (working);               // these lines represent
      tim.sleep (random.nextInt (maxWork));       // one unit of work
      System.out.println (falling);
      bucket.fallInto ();
      System.out.println (flushed);
    }
  }

}
