import jcsp.lang.*;
import java.util.*;

public class Flusher implements CSProcess {

  private final int interval;
  private final Bucket bucket;

  public Flusher (int interval, Bucket bucket) {
    this.interval = interval;
    this.bucket = bucket;
  }

  public void run () {

    final CSTimer tim = new CSTimer ();
    long timeout = tim.read () + interval;

    while (true) {
      tim.after (timeout);
      System.out.println ("*** Flusher: about to flush ...");
      final int n = bucket.flush ();
      System.out.println ("*** Flusher: number flushed = " + n);
      timeout += interval;
    }
  }

}
