import jcsp.lang.*;

public class Dingbat implements CSProcess {

  private final int id;
  private final Bucket[] bucket;

  public Dingbat (int id, Bucket[] bucket) {
    this.id = id;
    this.bucket = bucket;
  }

  public void run () {

    int logicalTime = 0;

    String[] spacer = new String[bucket.length];
    spacer[0] = "";
    for (int i = 1; i < spacer.length; i++) spacer[i] = spacer[i - 1] + "  ";

    String message = "Hello world from " + id + " ==> time = ";

    while (true) {
      logicalTime += id;
      final int slot = logicalTime % bucket.length;     // assume: id <= bucket.length
      bucket[slot].fallInto ();
      System.out.println (spacer[slot] + message + logicalTime);   // one unit of work
    }
  }

}
