import jcsp.lang.*;

class BucketKeeper implements CSProcess {

  private final long interval;
  private final Bucket[] bucket;

  public BucketKeeper (long interval, Bucket[] bucket) {
    this.interval = interval;
    this.bucket = bucket;
  }

  public void run () {

    String[] spacer = new String[bucket.length];
    spacer[0] = "";
    for (int i = 1; i < spacer.length; i++) spacer[i] = spacer[i - 1] + "  ";

    final CSTimer tim = new CSTimer ();
    long timeout = tim.read ();
    int index = 0;

    while (true) {
      final int n = bucket[index].flush ();
      if (n == 0) {
        System.out.println (spacer[index] + "*** bucket " + index + " was empty ...");
      }
      index = (index + 1) % bucket.length;
      timeout += interval;
      tim.after (timeout);
    }
  }

}
