import jcsp.lang.*;

public class BucketExample1 {

  public static void main (String[] args) {

    final int nWorkers = 10;

    final int second = 1000;                // JCSP timer units are milliseconds
    final int interval = 5*second;
    final int maxWork = 10*second;

    final long seed = new CSTimer ().read ();

    final Bucket bucket = new Bucket ();

    final Flusher flusher = new Flusher (interval, bucket);

    final Worker[] workers = new Worker[nWorkers];
    for (int i = 0; i < workers.length; i++) {
      workers[i] = new Worker (i, i + seed, maxWork, bucket);
    }

    System.out.println ("*** Flusher: interval = " + interval + " milliseconds");

    new Parallel (
      new CSProcess[] {
        flusher,
        new Parallel (workers)
      }
    ).run ();

  }

}
