import java.awt.*;
import java.net.*;

public class ImageLoader {

  final private static MediaTracker tracker = new MediaTracker (new Canvas ());

  public static Image[] load (BounceMain.Params params, final URL documentBase) {

    final int nImages = (params.to - params.from) + 1;
    if (nImages < 0) return null;

    final Image[] images = new Image[nImages];

    if (documentBase == null) {     // we're an application -- so load from a file
      for (int i = 0; i < nImages; i++) {
        String file = params.path + (i + params.from) + params.suffix;
        images[i] = Toolkit.getDefaultToolkit ().getImage (file);
        System.out.println ("ImageLoader.load: " + file + " " + images[i]);
      }
    } else {                        // we're an applet -- so load from a URL
      try {
        for (int i = 0; i < nImages; i++) {
          URL url = new URL (documentBase, params.path + (i + params.from) + params.suffix);
          images[i] = Toolkit.getDefaultToolkit ().getImage (url);
          System.out.println ("ImageLoader.load: " + url + " " + images[i]);
        }
      } catch (MalformedURLException e) {
        System.out.println ("ImageLoader.load: MalformedURLException" + e);
      }
    }

    for (int i = 0; i < nImages; i++) {
      tracker.addImage (images[i], 0);
    }
    try {
      tracker.waitForAll ();
    }
    catch (InterruptedException e) {
      System.out.println (e);
      System.exit (-1);
    }

    return images;

  }

}
