import java.awt.*;
import java.net.*;

import jcsp.lang.*;

public class BounceNetwork implements CSProcess {

  private final Bounce[] bounce;

  public BounceNetwork (final BounceMain.Params[] params,
                        final URL documentBase,
                        final Container parent) {

    bounce = new Bounce[params.length];

    final Object[] images = new Object[params.length];
    final Panel[] panel = new Panel[params.length];

    for (int i = 0; i < params.length; i++) {
      images[i] = ImageLoader.load (params[i], documentBase);
      bounce[i] = new Bounce ((Image[]) images[i],
                              params[i].background,
                              parent, params.length);
      panel[i] = bounce[i].getPanel ();
    }

    parent.setLayout (new GridLayout (params.length, 1));
    parent.add (panel[0]);
    parent.add (panel[1]);
    parent.add (panel[2]);

  }

  public void run () {

    new Parallel (bounce).run ();

  }

}

