import jcsp.lang.*;
import jcsp.awt.*;
import java.awt.*;

public class BallsNetwork2 implements CSProcess {

  private final ActiveCanvas activeCanvas;

  private final BallsControl2 control;

  private final Ball2[] balls;

  public BallsNetwork2 (final int nBalls, final int speed, final int life,
                        final Container parent) {

    parent.setLayout (new BorderLayout ());
    
    final DisplayList displayList = new DisplayList ();
    // displayList.setMinRefreshInterval (40);
    // System.out.println ("BallsNetwork2: displayList.setMinRefreshInterval (40) ...");

    final Barrier barrier = new Barrier ();
    final Barrier dead = new Barrier (nBalls);
    
    final Any2OneChannelInt fromBalls = new Any2OneChannelInt ();
    final One2OneChannel[] toBalls = One2OneChannel.create (nBalls);

    final One2OneChannel toGraphics = new One2OneChannel ();
    final One2OneChannel fromGraphics = new One2OneChannel ();

    activeCanvas = new ActiveCanvas ();
    activeCanvas.setBackground (Color.black);
    activeCanvas.setPaintable (displayList);
    activeCanvas.setGraphicsChannels (toGraphics, fromGraphics);
    activeCanvas.setSize (parent.getSize ());

    // If the parent is an applet, the above setSize has no effect and the activeCanvas
    // is fitted to the "Center" area (see below) of the applet's panel.

    // If the parent is a frame, the above *does* define the size of the activeCanvas
    // and the size of the parent is expanded to wrap around when it is packed.

    System.out.println ("BallsNetwork2 adding ActiveCanvas to the parent ...");
    parent.add ("Center", activeCanvas);

    final Ball2.Info[] oldInfo = new Ball2.Info[nBalls];
    final Ball2.Info[] newInfo = new Ball2.Info[nBalls];
    for (int i = 0; i < nBalls; i++) {
      oldInfo[i] = new Ball2.Info ();
      newInfo[i] = new Ball2.Info ();
    }

    balls = new Ball2[nBalls];
    for (int i = 0; i < nBalls; i++) {
      balls[i] = new Ball2 (i, speed, life, dead, fromBalls, toBalls[i],
                            barrier, oldInfo[i], newInfo[i]);
    }

    control = new BallsControl2 (fromBalls, toBalls, barrier,
                                 toGraphics, fromGraphics, displayList,
                                 oldInfo, newInfo, speed);

  }

  public void run () {

    System.out.println ("BallsNetwork starting up ...");

    new Parallel (
      new CSProcess[] {
        activeCanvas,
        new Parallel (balls),
        control
      }
    ).run ();

  }

}
