import jcsp.lang.*;
import jcsp.awt.*;
import java.awt.*;

public class BallsNetwork1 implements CSProcess {

  private final ActiveCanvas activeCanvas;

  private final BallsControl1 control;

  private final Ball1[] balls;

  public BallsNetwork1 (final int nBalls, final int speed, final int life,
                        final Container parent) {

    parent.setLayout (new BorderLayout ());
    
    final DisplayList displayList = new DisplayList ();
    // displayList.setMinRefreshInterval (10);
    // System.out.println ("BallsNetwork: displayList.setMinRefreshInterval (10) ...");

    final Barrier barrier = new Barrier ();
    final Barrier dead = new Barrier (nBalls);
    
    final One2OneChannel[] toBalls = One2OneChannel.create (nBalls);

    final One2OneChannel toGraphics = new One2OneChannel ();
    final One2OneChannel fromGraphics = new One2OneChannel ();

    activeCanvas = new ActiveCanvas ();
    activeCanvas.setBackground (Color.black);
    activeCanvas.setPaintable (displayList);
    activeCanvas.setGraphicsChannels (toGraphics, fromGraphics);
    activeCanvas.setSize (parent.getSize ());

    // If the parent is an applet, the above setSize has no effect and the activeCanvas
    // is fitted to the "Center" area (see below) of the applet's panel.

    // If the parent is a frame, the above *does* define the size of the activeCanvas
    // and the size of the parent is expanded to wrap around when it is packed.

    System.out.println ("BallsNetwork adding ActiveCanvas to the parent ...");
    parent.add ("Center", activeCanvas);

    balls = new Ball1[nBalls];
    for (int i = 0; i < nBalls; i++) {
      balls[i] = new Ball1 (i, speed, life, dead, toBalls[i], displayList, barrier);
    }

    control = new BallsControl1 (toBalls, barrier, displayList,
                                 toGraphics, fromGraphics, speed);

  }

  public void run () {

    System.out.println ("BallsNetwork starting up ...");

    new Parallel (
      new CSProcess[] {
        activeCanvas,
        new Parallel (balls),
        control
      }
    ).run ();

  }

}

