import jcsp.lang.*;
import jcsp.awt.*;
import java.awt.*;

public class BallsNetwork0 implements CSProcess {

  private final ActiveCanvas activeCanvas;

  private final BallsControl0 control;

  private final Ball0[] balls;

  public BallsNetwork0 (final int nBalls, final int speed, final int life,
                        final Container parent) {

    parent.setLayout (new BorderLayout ());
    
    final DisplayList displayList = new DisplayList ();
    // displayList.setMinRefreshInterval (10);
    // System.out.println ("BallsNetwork: displayList.setMinRefreshInterval (10) ...");
    
    final One2OneChannel[] toBalls = One2OneChannel.create (nBalls);

    final One2OneChannel toGraphics = new One2OneChannel ();
    final One2OneChannel fromGraphics = new One2OneChannel ();

    final Barrier dead = new Barrier (nBalls);

    activeCanvas = new ActiveCanvas ();
    activeCanvas.setBackground (Color.black);
    activeCanvas.setPaintable (displayList);
    activeCanvas.setGraphicsChannels (toGraphics, fromGraphics);
    activeCanvas.setSize (parent.getSize ());

    // If the parent is an applet, the above setSize has no effect and the activeCanvas
    // is fitted to the "Center" area (see below) of the applet's panel.

    // If the parent is a frame, the above *does* define the size of the activeCanvas
    // and the size of the parent is expanded to wrap around when it is packed.

    System.out.println ("BallsNetwork adding ActiveCanvas to the parent ...");
    parent.add ("Center", activeCanvas);

    balls = new Ball0[nBalls];
    for (int i = 0; i < nBalls; i++) {
      balls[i] = new Ball0 (i, speed, life, dead, toBalls[i], displayList);
    }

    control = new BallsControl0 (toBalls, displayList, toGraphics, fromGraphics);

  }

  public void run () {

    System.out.println ("BallsNetwork starting up ...");

    new Parallel (
      new CSProcess[] {
        activeCanvas,
        control,
        new Parallel (balls)
      }
    ).run ();

  }

}

