import jcsp.lang.*;

public final class VariateInt implements CSProcess {

  private final ChannelOutputInt out;
  private final int start, stop, n;

  public VariateInt (final ChannelOutputInt out, final int start,
                     final int stop, final int n) {
    this.out = out;
    this.start = start;
    this.stop = stop;
    this.n = n;
  }

  public void run () {

    final int innerCycleTime = n*start;

    final CSTimer tim = new CSTimer ();
    long timeout = tim.read ();

    while (true) {
      int interval = start;
      while (interval >= stop) {
        final int innerCycles = innerCycleTime/interval;
        for (int i = 0; i < innerCycles; i++) {
          out.write (interval);
          timeout += (long) interval;
          tim.after (timeout);
        }
        interval /= 2;
      }
    }

  }

}
