import jcsp.lang.*;

public class StressedAltInt {

  public static void main (String [] args) {

    final int nChannels = 8;
    final int nWritersPerChannel = 8;

    Any2OneChannelInt[] c = Any2OneChannelInt.create (nChannels);

    StressedWriterInt[] writers = new StressedWriterInt[nChannels*nWritersPerChannel];

    for (int channel = 0; channel < nChannels; channel++) {
      for (int i = 0; i < nWritersPerChannel; i++) {
        writers[(channel*nWritersPerChannel) + i] =
          new StressedWriterInt (c[channel], channel, i, nWritersPerChannel);
      }
    }

    new Parallel (
      new CSProcess[] {
        new Parallel (writers),
        new StressedReaderInt (c, nWritersPerChannel)
      }
    ).run ();

  }

}
