import jcsp.lang.*;
import jcsp.plugNplay.ints.PrinterInt;

final class RegulateIntTest {

  public static void main (String[] args) {

    final One2OneChannelInt a = new One2OneChannelInt ();
    final One2OneChannelInt b = new One2OneChannelInt ();
    final One2OneChannelInt reset = new One2OneChannelInt ();

    new Parallel (
      new CSProcess[] {
        new VariateInt (a, 5000, 10, 2),
        new RegulateInt (a, reset, b, 500),
        new PrinterInt (b, "RegulateTest ==> ", "\n"),
        new CSProcess () {
          // this controls the Regulate process, switching its firing
          // rate between a half and one second.  The switches occur
          // every five seconds.
          public void run () {
            final int halfSecond = 500;
            final int second = 1000;
            final CSTimer tim = new CSTimer ();
            long timeout = tim.read ();
            while (true) {
              timeout += 5000;
              tim.after (timeout);
              System.out.println ("                    <== now every second");
              reset.write (second);
              timeout += 5000;
              tim.after (timeout);
              System.out.println ("                    <== now every half second");
              reset.write (halfSecond);
            }
          }
        }
      }
    ).run ();

  }

}
