import jcsp.lang.*;

public class RegularInt implements CSProcess {

  final private ChannelOutputInt out;
  final private int n;
  final private long interval;

  public RegularInt (final ChannelOutputInt out, final int n, final long interval) {
    this.out = out;
    this.n = n;
    this.interval = interval;
  }

  public void run () {

    final CSTimer tim = new CSTimer ();
    long timeout = tim.read ();          // read the (absolute) time

    while (true) {
      out.write (n);
      timeout += interval;               // set the next (absolute) timeout
      tim.after (timeout);               // wait until that (absolute) timeout
    }
  }

}
