import jcsp.lang.*;
import jcsp.util.*;

public class StressedAlt {

  public static void main (String [] args) {

    final int nChannels = 8;
    final int nWritersPerChannel = 8;

    Any2OneChannel[] c = Any2OneChannel.create (nChannels, new OverWriteOldestBuffer (1));

    StressedWriter[] writers = new StressedWriter[nChannels*nWritersPerChannel];

    for (int channel = 0; channel < nChannels; channel++) {
      for (int i = 0; i < nWritersPerChannel; i++) {
        writers[(channel*nWritersPerChannel) + i] =
          new StressedWriter (c[channel], channel, i);
      }
    }

    new Parallel (
      new CSProcess[] {
        new Parallel (writers),
        new StressedReader (c, nWritersPerChannel)
      }
    ).run ();

  }

}
