import jcsp.lang.*;

public class PriPlexTime implements CSProcess {

  private final AltingChannelInput[] in;
  private final ChannelOutput out;
  private final long timeout;

  public PriPlexTime (final AltingChannelInput[] in, final ChannelOutput out,
                      final long timeout) {
    this.in = in;
    this.out = out;
    this.timeout = timeout;
  }

  public void run () {

    final Guard[] guards = new Guard[in.length + 1];
    System.arraycopy (in, 0, guards, 0, in.length);

    final CSTimer tim = new CSTimer ();
    final int timerIndex = in.length;
    guards[timerIndex] = tim;

    final Alternative alt = new Alternative (guards);

    boolean running = true;
    tim.setAlarm (System.currentTimeMillis () + timeout);
    while (running) {
      final int index = alt.priSelect ();
      if (index == timerIndex) {
        running = false;
      } else {
        out.write (in[index].read ());
      }
    }
    System.out.println ("Goodbye from PriPlexTime ...");
    System.out.println ("You'll need to ctl<C>, sorry ...");

  }

}
