import jcsp.lang.*;

class Phil implements CSProcess {
  
  //{{{  COMMENT documentation
  //
  //A Philosopher thinks for a while -- around 3 seconds -- and then goes to the
  //Canteen for food, consuming what he gets straight away.   This cycle continues
  //indefinitely.
  //
  //Except, that is, for Philosopher 0 ...  who refuses to think and just keeps
  //going to the Canteen.
  //
  //For this Canteen, when there's no chicken, the Philosphers are just kept
  //waiting in the service queue.  The greedy Philosopher no longer loses his
  //place through getting in before the food is cooked and doesn't starve.
  //
  //}}}
  
  private final  int id;
  
  private final ChannelOutputInt service;
  private final ChannelInputInt deliver;
  
  public Phil (int id, ChannelOutputInt service, ChannelInputInt deliver) {
    this.id = id;
    this.service = service;
    this.deliver = deliver;
  }
  
  public void run () {
    final CSTimer tim = new CSTimer ();
    System.out.println ("      Phil " + id + "  : starting ... ");
    while (true) {
      // everyone, bar Philosopher 0, has a little think
      if (id > 0) {
        tim.after (tim.read () + 3000);   // thinking
      }
      // want chicken
      System.out.println ("      Phil " + id + "  : gotta eat ... ");
      service.write (0);
      deliver.read ();
      System.out.println ("      Phil " + id + "  : mmm ... that's good ... ");
    }
  }
  
}
