import jcsp.lang.*;

class College {

  //{{{  COMMENT documentation
  //
  //The College consists of 5 Philosophers, a Chef and the Canteen.  All are
  //"active" objects.  The Canteen ALTs between a service Channel, shared by
  //all the Philosophers, and a supply Channel from the Chef.  Upon acceptance
  //of a service request, chickens are dispensed through a delivery Channel.
  //
  //Despite the greedy behaviour of Philosopher 0, nobody starves.  The Canteen
  //guards the service Channel so that Philosophers cannot blunder in when there
  //are no chickens, but are held waiting in the service queue.  There is no
  //concept now of a "stand-bye" queue to which they are sent, thereby losing
  //their place in the main queue.
  //
  //}}}

  public static void main (String argv[]) {

    int n_philosophers = 5;

    final Any2OneChannelInt service = new Any2OneChannelInt ();
    final One2OneChannelInt deliver = new One2OneChannelInt ();
    final One2OneChannelInt supply = new One2OneChannelInt ();
    
    final Phil[] phil = new Phil[n_philosophers];
    for (int i = 0; i < n_philosophers; i++) {
      phil[i] = new Phil (i, service, deliver);
    }

    new Parallel (
      new CSProcess[] {
        new Clock (),
        new Canteen (service, deliver, supply),
        new Chef (supply),
        new Parallel (phil)
      }
    ).run ();
    
  }
  
}
