import jcsp.lang.*;
import jcsp.awt.*;
import java.awt.*;

import phw.util.Ask;

/**
 * This example is based on
 * <A HREF="http://rsb.info.nih.gov/plasma/">Sam's Java Plasma Applet</A>
 * by <A HREF="mailto:t-sammar@microsoft.com">Sam Marshall</A>.  It was modified to use
 * 8-bit images by <A HREF="mailto:M.vanGangelen@element.nl">Menno van Gangelen</A>.
 * This JCSP demonstration is by <A HREF="mailto:P.H.Welch@ukc.ac.uk">Peter Welch</A>.
 */

public class PlasmaMain extends ActiveApplet {

  public static final int minWidth = 256;
  public static final int minHeight = 256;

  public static final int maxWidth = 1024;
  public static final int maxHeight = 768;

  public void init () {
    setProcess (new PlasmaNetwork (this));
  }

  public static void main (String[] args) {

    System.out.println ("\nWelcome to Plasma ...\n");

    final int width = Ask.Int ("width = ", minWidth, maxWidth);
    final int height = Ask.Int ("height = ", minHeight, maxHeight);
    System.out.println ();

    final ActiveClosingFrame activeClosingframe = new ActiveClosingFrame ("Plasma");
    final ActiveFrame activeFrame = activeClosingframe.getActiveFrame ();
    activeFrame.setSize (width, height);

    final PlasmaNetwork plasmaNetwork = new PlasmaNetwork (activeFrame);

    activeFrame.pack ();
    activeFrame.setLocation ((maxWidth - width)/2, (maxHeight - height)/2);
    activeFrame.setVisible (true);
    activeFrame.toFront ();

    new Parallel (
      new CSProcess[] {
        activeClosingframe,
        plasmaNetwork
      }
    ).run ();

  }

}
