import jcsp.lang.*;

class DiningPhilosophersCollege implements CSProcess {

  private final int nPhilosophers;
  private final ChannelOutput report;

  public DiningPhilosophersCollege (int nPhilosophers, ChannelOutput report) {
    this.nPhilosophers = nPhilosophers;
    this.report = report;
  }

  public void run () {

    final One2OneChannel[] left = One2OneChannel.create (nPhilosophers);
    final One2OneChannel[] right = One2OneChannel.create (nPhilosophers);

    final Any2OneChannel down = new Any2OneChannel ();
    final Any2OneChannel up = new Any2OneChannel ();

    final Fork[] fork = new Fork[nPhilosophers];
    for (int i = 0; i < nPhilosophers; i++) {
      fork[i] = new Fork (nPhilosophers, i,
                          left[i], right[(i + 1)%nPhilosophers], report);
    }

    final Philosopher[] phil = new Philosopher[nPhilosophers];
    for (int i = 0; i < nPhilosophers; i++) {
      phil[i] = new Philosopher (i, left[i], right[i], down, up, report);
    }

    new Parallel (
      new CSProcess[] {
        new Parallel (phil),
        new Parallel (fork),
        new Security (down, up, report),
        new Clock (report)
      }
    ).run ();

  }

}
