import jcsp.lang.*;

class Clock implements CSProcess {

  // protected attributes

  protected static final int seconds = 1000;
  protected static final int period = 1*seconds;

  protected ChannelOutput report;

  // constructors

  public Clock (ChannelOutput report) {
    this.report = report;
  }

  // public methods

  public void run () {
    int tick = 0;
    while (true) {
      report.write (new ClockReport (tick));
      sleep (period);
      tick++;
    }
  }

  // protected methods

  protected void sleep (long t) {
    try {
      Thread.sleep (t);
    } catch (InterruptedException e) {};
  }

}
