import jcsp.lang.*;
import java.util.*;

public class Worker implements CSProcess {

  private final int id;
  private final long seed;
  private final int maxWork;
  private final boolean rogue;
  private final Barrier barrier;

  public Worker (int id, long seed, int maxWork, boolean rogue, Barrier barrier) {
    this.id = id;
    this.seed = seed;
    this.maxWork = maxWork;
    this.rogue = rogue;
    this.barrier = barrier;
  }

  public void run () {

    final Random random = new Random (seed);        // each process gets a different seed

    final CSTimer tim = new CSTimer ();
    final int second = 1000;                        // JCSP timer units are milliseconds

    final int minRest = 3*second;
    final int maxRest = (id + 10)*second;
    final int nWorkUnits = id + 1;

    final String starting = "\tWorker " + id + " starting ...";
    final String  working = "\t\t\t  ... Worker " + id + " working ...";
    final String  resting = "\t\t\t\t\t       ... Worker " + id + " resting ...";

    while (true) {
      barrier.enroll ();
      System.out.println (starting);
      for (int i = 0; i < nWorkUnits; i++) {
        barrier.sync ();
        barrier.sync ();
        System.out.println (working);               // these lines represent
        tim.sleep (random.nextInt (maxWork));       // one unit of work
      }
      if (rogue) tim.sleep (maxWork);               // try to throw the timekeeper
      barrier.resign ();
      System.out.println (resting);
      tim.sleep (minRest + random.nextInt (maxRest));
    }
  }

}
