import jcsp.lang.*;

public class Player implements CSProcess {

  private final int id, nPlayers;
  private final Barrier barrier;

  public Player (int id, int nPlayers, Barrier barrier) {
    this.id = id;
    this.nPlayers = nPlayers;
    this.barrier = barrier;
  }

  public void run () {
    final CSTimer tim = new CSTimer ();
    final long second = 1000;          // JCSP timer units are milliseconds
    int busy = id + 1;
    while (true) {
      tim.sleep (busy*second);         // application specific work
      System.out.println ("Player " + id + " at the barrier ...");
      barrier.sync ();
      System.out.println ("\t\t\t... Player " + id + " over the barrier");
      busy = (nPlayers + 1) - busy;    // just to make it more interesting
    }
  }

}
