import java.awt.Point;
import phw.util.Ask;

class SprayTest {

  public static void main (String[] args) {

    int radius = 20;
    byte[][] cell = new byte[50][50];
    byte[] pixels = new byte[50*50];
    int[] count = new int[Cell.N_STATES];

    count[Cell.GREEN] = 50*50;
    count[Cell.INFECTED] = 0;
    count[Cell.DEAD] = 0;
    
    Spray spray = new Spray (radius, cell, pixels, count);

    char[] which = {'g', 'i', 'd'};

    while (true) {
      System.out.println ();
      final int i = Ask.Int ("i = ", 0, 49);
      final int j = Ask.Int ("j = ", 0, 49);
      final char ch = Ask.Char ("g/i/d? ", which);
      final byte state = (ch == 'g') ? Cell.GREEN : (ch == 'i') ? Cell.INFECTED : Cell.DEAD;
      System.out.println ();
      spray.zap (new Point (i, j), state);
      spray.printCells ();
      System.out.println ();
      System.out.println ("GREEN = " + count[Cell.GREEN]);
      System.out.println ("INFECTED = " + count[Cell.INFECTED]);
      System.out.println ("DEAD = " + count[Cell.DEAD]);
      spray.setMask ();
    }
  }

}
