import jcsp.lang.*;
import jcsp.awt.*;
import java.awt.*;

import phw.util.Ask;

public class InfectMain extends ActiveApplet {

  public static final int minWidth = 350;
  public static final int maxWidth = 1024;

  public static final int minHeight = 350;
  public static final int maxHeight = 768;

  public static final int minRate = 0;
  public static final int maxRate = 100;
  public static final int standbyRate = 35;

  public void init () {
    final int rate = getAppletInt ("rate", minRate, maxRate, standbyRate);
    setProcess (new InfectNetwork (rate, this));
  }

  public static void main (String[] args) {

    System.out.println ("\nInfect starting ...\n");

    final int width = Ask.Int ("width = ", minWidth, maxWidth);
    final int height = Ask.Int ("height = ", minHeight, maxHeight);
    System.out.println ();

    final int rate = Ask.Int ("rate = ", minRate, maxRate);
    System.out.println ();

    final ActiveClosingFrame activeClosingframe = new ActiveClosingFrame ("Infect");
    final ActiveFrame activeFrame = activeClosingframe.getActiveFrame ();
    activeFrame.setSize (width, height);

    final InfectNetwork infect = new InfectNetwork (rate, activeFrame);

    activeFrame.pack ();
    activeFrame.setLocation ((maxWidth - width)/2, (maxHeight - height)/2);
    activeFrame.setVisible (true);
    activeFrame.toFront ();

    new Parallel (
      new CSProcess[] {
        activeClosingframe,
        infect
      }
    ).run ();

  }

}
