import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;
import java.awt.*;

public class FireNetwork implements CSProcess {

  private final ActiveCanvas activeCanvas;

  private final FireControl control;

  public FireNetwork (int maxParticles, int stillCount, int dragCount, int speed,
                      int accY, int maxDeltaY, int launchDeltaX, int launchDeltaY,
                      int scale, Container parent) {

    parent.setLayout (new BorderLayout ());
    
    final DisplayList displayList = new DisplayList ();
    // displayList.setMinRefreshInterval (10);
    // System.out.println ("FireNetwork: displayList.setMinRefreshInterval (10) ...");
    
    // final Any2OneChannel fromMouse = Any2OneChannel.create (new OverWriteOldestBuffer (9));
    final One2OneChannel fromMouse = One2OneChannel.create (new OverWriteOldestBuffer (9));
    final One2OneChannel fromMouseMotion = One2OneChannel.create (new OverWriteOldestBuffer (9));
    final One2OneChannel fromKeyboard = One2OneChannel.create (new OverWriteOldestBuffer (9));

    final One2OneChannel toGraphics = new One2OneChannel ();
    final One2OneChannel fromGraphics = new One2OneChannel ();

    activeCanvas = new ActiveCanvas ();
    activeCanvas.setBackground (Color.black);
    activeCanvas.setPaintable (displayList);
    activeCanvas.setGraphicsChannels (toGraphics, fromGraphics);
    activeCanvas.addMouseEventChannel (fromMouse);
    activeCanvas.addMouseMotionEventChannel (fromMouseMotion);
    activeCanvas.addKeyEventChannel (fromKeyboard);
    activeCanvas.setSize (parent.getSize ());

    // If the parent is an applet, the above setSize has no effect and the activeCanvas
    // is fitted to the "Center" area (see below) of the applet's panel.

    // If the parent is a frame, the above *does* define the size of the activeCanvas
    // and the size of the parent is expanded to wrap around when it is packed.

    System.out.println ("FireNetwork adding ActiveCanvas to the parent ...");
    parent.add ("Center", activeCanvas);

    control = new FireControl (
      fromMouse, fromMouseMotion, fromKeyboard, displayList, toGraphics, fromGraphics,
      maxParticles, stillCount, dragCount, speed, accY, maxDeltaY,
      launchDeltaX, launchDeltaY, scale
    );

  }

  public void run () {

    System.out.println ("FireControl starting up ...");

    new Parallel (
      new CSProcess[] {
        activeCanvas,
        control
      }
    ).run ();

  }

}

