//{{{}}}
//{{{  COMMENT documentation
//|
//|                       The Scribbling Philosophers
//|                       ===========================
//|
//| This program demonstrates the Crew class for Concurrent-read-exclusive-write
//| access to a shared object.
//| 
//| A college consists of five philosophers and a blackboard.  The philosophers spend
//| their time between thinking, looking at what others have written on the blackboard
//| and scribbling on the blackboard themselves.
//| 
//| Access to the blackboard is a bit constrained, so only one at a time may scribble.
//| Any number of philosophers may read the blackboard simultaenously, but not whilst
//| a scribbler is scribbling -- space is so tight that someone scribbling on the board
//| completely blocks the view.
//|
//|                              ______________
//|                              |            |       _______________
//|                              | blackboard |       |             |
//|    ---------------------<->--|            |   /-<-|  TimeKeeper |
//|      |   |   |   |   |       |   (CREW)   |   |   |_____________|
//|      :)  :)  :)  :)  :)      |____________|   |
//|      1   2   3   4   5                        v    _______________
//|      |   |   |   |   |                        |    |             |
//|    ---------------------->-------------------------| TextDisplay |
//|                   display/displayInfo              |_____________|
//|
//|
//}}}

import jcsp.lang.*;

class CrewCollege {

  public static void main (String argv[]) {

    final int n_philosophers = 10;
    final int blackboard_size = 10;

    final int[] blackboard = new int[blackboard_size];
    for (int i = 0; i < blackboard_size; i++) {             // initially, there is
      blackboard[i] = -1;                                   // garbage in the shared
    }                                                       // resource (blackboard)

    final Crew crewBlackboard = new Crew (blackboard);

    final Any2OneChannelInt display = new Any2OneChannelInt ();
    final One2OneChannelInt displayInfo = new One2OneChannelInt ();

    final CrewPhilosopher[] phil = new CrewPhilosopher[n_philosophers];
    for (int i = 0; i < n_philosophers; i++) {
      phil[i] = new CrewPhilosopher (i, crewBlackboard, display, displayInfo);
    }

    final TimeKeeper timeKeeper = new TimeKeeper (display, displayInfo);

    final CrewDisplay crewDisplay = new CrewDisplay (display, displayInfo);

    new Parallel (
      new CSProcess[] {
        new Parallel (phil),
        timeKeeper,
        crewDisplay
      }
    ).run ();

  }

}

