import jcsp.lang.*;

class Consume implements CSProcess {

  private int nLoops;
  private ChannelInputInt in;

  public Consume (int nLoops, ChannelInputInt in) {
    this.nLoops = nLoops;
    this.in = in;
  }

  public void run () {

    int x = -1;
    int warm_up = 1000;
    System.out.print ("warming up ... ");
    for (int i = 0; i < warm_up; i++) {
      x = in.read ();
    }
    System.out.println ("last number received = " + x);

    System.out.println ("1000 cycles completed ... timing now starting ...");

    while (true) {

      long t0 = System.currentTimeMillis ();
      for (int i = 0; i < nLoops; i++) {
        x = in.read ();
      }
      long t1 = System.currentTimeMillis ();

      System.out.println ("last number received = " + x);
      long microseconds   = (t1 - t0) * 1000;
      long timePerLoop_us = (microseconds / ((long) nLoops));
      System.out.println ("   " + timePerLoop_us + " microseconds / iteration");
      timePerLoop_us = (microseconds / ((long) (4*nLoops)));
      System.out.println ("   " + timePerLoop_us + " microseconds / communication");
      timePerLoop_us = (microseconds / ((long) (8*nLoops)));
      System.out.println ("   " + timePerLoop_us + " microseconds / context switch");

    }

  }

}
