import jcsp.lang.*;
import jcsp.awt.*;
import java.awt.*;

import phw.util.Ask;

public class BounceMain extends ActiveApplet {

  public static final int minWidth = 300;
  public static final int minHeight = 100;

  public static final int maxWidth = 1024;
  public static final int maxHeight = 768;

  public static final Params[] params =
    {new Params ("images/cube/", 1, 5, ".gif", Color.white),
     new Params ("images/duke/", 1, 17, ".gif", Color.lightGray),
     new Params ("images/earth/", 1, 30, ".gif", Color.white)};

  public void init () {
    setProcess (new BounceNetwork (params, getDocumentBase (), this));
  }

  public static void main (String[] args) {
  
    System.out.println ("\nBounce starting ...\n");

    final int width = Ask.Int ("width = ", minWidth, maxWidth);
    final int height = Ask.Int ("height = ", minHeight, maxHeight);
    System.out.println ();

    final ActiveClosingFrame activeClosingframe = new ActiveClosingFrame ("Bounce");
    final ActiveFrame activeFrame = activeClosingframe.getActiveFrame ();
    activeFrame.setSize (width, height);

    final BounceNetwork bounceNetwork = new BounceNetwork (params, null, activeFrame);

    activeFrame.pack ();
    activeFrame.setLocation ((maxWidth - width)/2, (maxHeight - height)/2);
    activeFrame.setVisible (true);
    activeFrame.toFront ();

    new Parallel (
      new CSProcess[] {
        activeClosingframe,
        bounceNetwork
      }
    ).run ();

  }

  public static class Params {

    public final String path, suffix;
    public final int from, to;
    public final Color background;

    public Params (String path, int from, int to, String suffix,
                   Color background) {
      this.path = path;
      this.from = from;
      this.to = to;
      this.suffix = suffix;
      this.background = background;
    }

 }

}
