import jcsp.lang.*;

public class StressedWriter implements CSProcess {

  private final ChannelOutput out;
  private final int channel;
  private final int writer;
  private final String id;

  public StressedWriter (ChannelOutput out, int channel, int writer) {
    this.out = out;
    this.channel = channel;
    this.writer = writer;
    this.id = "channel " + channel + " writer " + writer;
  }

  public void run () {
    int n = 0;
    StressedPacket stressedPacketA = new StressedPacket (writer);
    StressedPacket stressedPacketB = new StressedPacket (writer);
    while (true) {
      // for (int i = 0; i < writer; i++) System.out.print ("  ");
      // System.out.println (id + " " + n);
      stressedPacketA.n = n;
      out.write (stressedPacketA);
      n++;
      // for (int i = 0; i < writer; i++) System.out.print ("  ");
      // System.out.println (id + " " + n);
      stressedPacketB.n = n;
      out.write (stressedPacketB);
      n++;
    }
  }

}
