package newjcircusutil.multisync;

import java.util.*;
import test.CommException;
import test.Cte;
import test.Print;
import org.jcsp.lang.*;

/*
 * Controls the multi-synchronisation of multiple processes
 * in a given channel
 *
 * @author  Angela Freitas
 */
public class MultiSyncControlSimple implements CSProcess{
    
    private String cname;
    
    // Writer id
    private int id;

    // Number of clients wanting to synchronise on the channel
    private int numberOfClients;
    
    // Answer from the SyncControl to the clients
    private ChannelOutput[] fromSync;

    // Request from a client to synchronise
    private ChannelInput toSync;

    /* 
     * Creates a new instance of SyncControl 
     * @param int numberOfClients - Number of clients wanting to synchronise on the channel
     * @param ChannelOutput[] fromSync - Answer from the SyncControl to the clients
     * @param ChannelInput toSync - Request from a client to synchronise
     */
    public MultiSyncControlSimple(String cname, ChannelOutput[] fromSync, ChannelInput toSync) {
        this.cname = cname;
        this.id = 0;                    
        this.numberOfClients = fromSync.length;
        this.fromSync = fromSync;
        this.toSync = toSync;
    }
    
    /* 
     * Runs this process
     */
    public void run() {
        try {
            this.offer(this.numberOfClients);
        } catch (Throwable t) {
            throw new CommException("Exception in controller for channel " + cname, t);
        }
    }

    /* 
     * Receives offers to synchronise from the clients
     * @param int countDown - Number of clients still to send the offer
     */
    private void offer(int countdown) { // X
        
        if (countdown > 0  && countdown <= this.numberOfClients) {
            Print.print("cdown =  " + countdown, this.getClass(), cname);
            Integer x = (Integer)toSync.read();
            Print.print("C read " + x + " from to_" + cname, this.getClass(), cname);
            int nextOffer = x.intValue();
            if (nextOffer >= 0) {
                this.offer(countdown-1);
            } else if (nextOffer < 0){
                this.offer(countdown+1);
            }
        } else if (countdown == 0) {
            this.invite(0);
        }
    }
    
    /* 
     * Invites the clients to commit
     * @param int client - The client to invite
     */
    private void invite(int client) { // Y
        
        if (client < numberOfClients) {
            this.fromSync[client].write(new Boolean(true));
            this.invite(client+1);
        } else if (client == numberOfClients) {
            this.invitePrime(0,this.numberOfClients);
        }
    }

    /* 
     * Accepts commitments from the clients
     * @param int client - Next client to receive the commitment
     * @param int coutndown - Number of clients still to send the commitment
     */
    private void invitePrime(int client, int countdown) { // Z
        
        if (client >= 0 && client < this.numberOfClients) {
            int nextCommit = ((Integer)this.toSync.read()).intValue();
            if (nextCommit >= 0) {
                this.invitePrime(client+1,countdown-1);
            } else if (nextCommit < 0) {
                this.invitePrime(client+1,countdown);
            }
        } else if (client == this.numberOfClients) {
            this.sync(0,countdown);
        }
    }
    
    /* 
     * Try to synchronise with the clients
     * @param int client - Next client to synchronise
     * @param int coutndown - Number of clients still to synchronise
     */
    private void sync(int client, int countdown) { // W
        
        if (client < numberOfClients) {
            
            this.fromSync[client].write(new Boolean(countdown==0));
            this.sync(client+1, countdown);
            
        } else if (client == numberOfClients) {
            this.offer(this.numberOfClients);
        }
    }

}

