package newjcircusutil.multisync;

import java.util.*;
import test.Cte;
import test.Print;
import org.jcsp.lang.*;

/*
 * Client Synchronise on a multiple channels
 *
 * @author  Angela Freitas
 */
public class MultiSyncClientSimple implements CSProcess{
    
    /* Index of elements of the SYNCs objects */
    private final int FROM_INDEX      = 0;
    private final int TO_INDEX        = 1;
    private final int SYNC_ID_INDEX   = 2;
    private final int WRITER_ID_INDEX = 3;
    
    /* Synchronising Channels */
    private AltingChannelInput from;
    private ChannelOutput to;
    
    /* No-Synchronising Channels */
    private AltingChannelInput interrupt;

    /* Id of this process in the multisynchronization */
    private Integer id;
    
    private String cname;
    
    /* Creates a new instance of SyncClient 
     * @param Integer id - Identifier of this client
     * @param List seqOfSync - List of synchronisations. Each synchronisation is 
     * an array in the form {from_channel, to_channel, id}, where id is the identifier
     * of this client in the channel multi-synchronisation
     * @param List listOfNotSeq List of interruptions which can occur in this client
     * @param Object valueTrasn - Value transmitted in a communication
     */
    public MultiSyncClientSimple(String cname, AltingChannelInput from, ChannelOutput to, AltingChannelInput interrupt, Integer id) {
        this.from = from;
        this.to = to;
        this.interrupt = interrupt;
        this.id = id;
        this.cname = cname;
    }

    public void run() {
        
        try {
            offer();
        } catch (Exception e) {
            throw new RuntimeException();
        }
    }

    private void offer() {

        Print.print("(1) will write on to_" + cname, this.getClass(), this.id.intValue() + "");
        to.write(this.id);
        Print.print("(1) wrote on to_" + cname, this.getClass(), this.id.intValue() + "");
        Alternative alt;
        
        if (this.interrupt != null)
            alt = new Alternative(new Guard[] {this.from, this.interrupt}); 
        else
            alt = new Alternative(new Guard[] {this.from}); 
        
        int chosen = alt.priSelect();
        
        if (chosen == 0) {
            // Chose the from (multisync)
            from.read();
            to.write(id);
            Boolean sync = (Boolean) from.read();
            
            if (sync.equals(Boolean.TRUE)) {
                return;
            } else {
                // synchronization has not occured. Has to come back to choose the interrupt
                offer();
            }
            
        } else if (chosen == 1) {
            
            // Chose the interrupt
            
            // Reads from the interrupt channel
            interrupt.read();
            
            // Treatment of interruption
            final Integer thisId = this.id;
            // Interleaving
            CSProcess process = new CSProcess() {
                public void run () {
                    CSProcess first = new CSProcess() {
                        public void run () {
                            to.write(AuxiliarMethods.flip(thisId));
                        }
                    };
                    CSProcess second = new CSProcess() {
                        public void run () {
                            Boolean invite = (Boolean)from.read();
                            if (invite.booleanValue()) {
                                from.read();
                            } else if (!invite.booleanValue()) {
                            }
                        }
                    };
                    CSProcess[] procs = new CSProcess[]{first,second};
                    Parallel intInterleave = new Parallel(procs);
                    intInterleave.run();
                }
            };
            
            // Returns instead of calling offer
            return;
            
        } // (code for interruption)

    }
}
