package newjcircusutil.multisync;

import java.util.Vector;



/*
 * Provides some auxiliar methods used in the system
 *
 * Created on 15 May 2003, 18:51
 * @author  Marcel Oliveira
 */
public class AuxiliarMethods {
    
    /*
     * Verifies if the given number belongin the given array
     *
     * @param int number The number to be verified
     * @param int[] intArray The array in which the number should exist
     */
    public static boolean exists(int number, int[] intArray){
        boolean exists = false;
        for(int i=0; i<intArray.length-1 && !exists; i++){
            if (intArray[i]==number){
                exists = true;
            }
        }
        return exists;
    }
    
    /* 
     * Flips a given integer
     * @param Integer i - The integer to be flipped
     * @return Integer - The flipped i
     */
    public static Integer flip(Integer i) {
        return new Integer(-(i.intValue()+1));
    }
    
    /**
     * Angela.
     */

    /**
     * Returns a new array with new GeneralChannel objects constructed from
     * the old ones, but changing only the id attribute.
     *
     * Change Object by GeneralChannel.
     */
    public static Object[] auxi(Object[] a, Integer id) {
    
        Object[] r = a.clone(); //new Object[a.length];
        
        for (int i=0; i<a.length; i++) {
            
            Object elem = a[i];
            Object newElem = null;
            
            if (elem instanceof Object[]) {
                // Recursive case
                newElem = auxi((Object[]) elem, id);
            } else if (elem instanceof GeneralChannel) {
                // Base case
                newElem = new GeneralChannel((GeneralChannel)elem, id);
            } else {
                throw new RuntimeException("Unexpected");
            }
            r[i] = newElem;
        }
        return r;
    }
    

    
    /**
     * Returns true if the arrays are equivalent, that is, if the base elements
     * are equal.
     * 
     * This method is only for testing.
     */
    public static boolean equiv(Object[] a, Object[] b) {
    
        if (a.length != b.length)
            return false;
        
        for (int i=0; i<a.length; i++) {
            
            Object elemA = a[i];
            Object elemB = b[i];
            
            if (elemA instanceof Object[] && elemB instanceof Object[]) {
                // Recursive case
                return equiv((Object[]) elemA, (Object[]) elemB);
                
            } else if (elemA instanceof GeneralChannel && 
                    elemB instanceof GeneralChannel) {
                
                // Base case
                GeneralChannel ga = (GeneralChannel) elemA;
                GeneralChannel gb = (GeneralChannel) elemB;
                
                if (!(ga.getFromController().equals(gb.getFromController()) &&
                        ga.getToController().equals(gb.getToController()) &&
                        ga.getChannelInfo().equals(gb.getChannelInfo()) &&
                        ga.getProcId().equals(gb.getProcId())
                        )) {
                    // If the channels are not equal return false; otherwise
                    // continue
                    return false;
                }
            } else {
                throw new RuntimeException("A and B are not equivalent");
            }
        }
        
        // If no case base returned false, then return true.
        return true;
    }   

    public static MultiSyncControl[] getArrayMultiSyncControl(Object[] array) {
        
        Vector<MultiSyncControl> v = get(array);
        MultiSyncControl r[] = new MultiSyncControl[v.size()];
        
        for (int i=0; i<v.size(); i++) {
            r[i] = v.get(i);
        }

        return r;
    }
    
    private static Vector<MultiSyncControl> get(Object[] array) {

        Vector<MultiSyncControl> r = new Vector();
        
        for (Object o: array) {
            if (o instanceof Object[])
                r.addAll(get((Object[])o));
            else
                r.add((MultiSyncControl)o);
        }
        return r;
    }
    
}
