/*
 * Class responsible for the internationalisation of the messages
 *
 * Created on 14 May 2003, 15:36
 * @author  Marcel Oliveira
 */

package fireControlSystem.util;

import java.util.Locale;
import java.util.ResourceBundle;

public class International{

    private static International international;
    private ResourceBundle messages;

    private International(String language, String country) {
        Locale locale = new Locale(language, country);
        this.messages = ResourceBundle.getBundle("messages", locale);
    }
    public static International getInstance(){
        if(international == null){
            international = new International("en","uk");
        }
        return international;
    }
    public String getMessage(String code) {
        String message = messages.getString(code);
        return message;
    }
}
