package fireControlSystem.util;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.typing.*;
import fireControlSystem.gui.*;
import fireControlSystem.processes.*;
import fireControlSystem.util.*;

/*
 * Class responsible for executing the tests
 *
 * Created on 13 May 2003, 11:34
 * @author  Marcel Oliveira
 */
public class GenericTest {

    public static final Integer SYNC_WRITER_ID = new Integer(0);
    private final int delay = 3000;
    
    /* Creates a new instance of GenericTest */
    public GenericTest() {
    }
 
    public void testMultiSync() {
        int NUMBER_OF_CLIENTS = 2;
        int SYNC_CHANNELS = 2;
        
        Any2OneChannel[] from_m = Any2OneChannel.create(NUMBER_OF_CLIENTS);
        Any2OneChannel to_m = new Any2OneChannel();
        
        Any2OneChannel[] from_n = Any2OneChannel.create(NUMBER_OF_CLIENTS);
        Any2OneChannel to_n = new Any2OneChannel();
        
        CSProcess[] controlProcesses = new CSProcess[SYNC_CHANNELS];
        MultiSyncControl controlM = new MultiSyncControl(from_m,to_m);
        MultiSyncControl controlN = new MultiSyncControl(from_n,to_n);
        controlProcesses[0] = controlM;
        controlProcesses[1] = controlN;
        Parallel controllers = new Parallel(controlProcesses);
        
        CSProcess[] clientProcesses = new CSProcess[NUMBER_OF_CLIENTS];
        for(int i=0; i<NUMBER_OF_CLIENTS; i++) {
            Vector seqOfSync = new Vector();
            Object[] sync_m = new Object[]{from_m[i], to_m, new Integer(i),SYNC_WRITER_ID};
            Object[] sync_n = new Object[]{from_n[i], to_n, new Integer(i),SYNC_WRITER_ID};
            seqOfSync.addElement(sync_m);
            seqOfSync.addElement(sync_n);
            
            Vector seqOfNotSync = new Vector();
            
            if (i==GenericTest.SYNC_WRITER_ID.intValue()) {
                MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, new Integer(100));
                clientProcesses[i] = client;
            } else {
                MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, null);
                clientProcesses[i] = client;
            }
        }
        Parallel clients = new Parallel(clientProcesses);
        
        CSProcess[] multiSystemProcesses = new CSProcess[]{controllers,clients};
        Parallel multiSystem = new Parallel(multiSystemProcesses);
        multiSystem.run();
    }
    
    public static void main(String args[]) {
        GenericTest test = new GenericTest();
        test.testMultiSync();
    }
}
