package fireControlSystem.typing;

/*
 * Represents the System State
 *
 * Created on 27 May 2003, 18:54
 * @author  Marcel Oliveira
 */
public class SystemState extends Type {
    
    /* Ids of existent lamps */
    public static final int FIRE_SYS_START = 0;
    public static final int FIRE_SYS       = 1;
    public static final int FIRE_SYS_D     = 2;
    public static final int AUTO           = 3;
    public static final int COUNTDOWN      = 4;
    public static final int DISCHARGE      = 5;
    public static final int RESET          = 6;
    public static final int MANUAL         = 7;
    public static final int DISABLED       = 8;
    
    /* Limits of the lamps ids */
    public static final int MIN_SYSTEM_STATE = 0;
    public static final int MAX_SYSTEM_STATE = 8;

    /*
     * Creates a new instance of SystemState with the respective value 
     * @param value The value of the object SystemState
     */
    public SystemState(int value) {
        this.setValue(value);
    }
}
