package fireControlSystem.typing;

/*
 * Represents the Lamps Ids of the system
 *
 * Created on 12 May 2003, 10:22
 * @author  Marcel Oliveira
 */
public class LampId extends Type {
    
    /* Ids of existent lamps */
    public static final int ZONE_FAULT_LAMP            = 0;
    public static final int EARTH_FAULT_LAMP           = 1;
    public static final int SOUNDER_LINE_FAULT_LAMP    = 2;
    public static final int POWER_FAULT_LAMP           = 3;
    public static final int ISOLATE_REMOTE_SIGNAL_LAMP = 4;
    public static final int ACTUATOR_LINE_FAULT_LAMP   = 5;
    public static final int ALARM_SILENCED_LAMP        = 6;
    public static final int SYSTEM_ON_LAMP             = 7;
    public static final int CIRCUIT_FAULT_LAMP         = 8;
    
    /* Limits of the lamps ids */
    public static final int MIN_LAMP_ID = 0;
    public static final int MAX_LAMP_ID = 8;

    /*
     * Creates a new instance of AreaId with the respective value 
     * @param value The value of the object LampId
     */
    public LampId(int value) {
        this.setValue(value);
    }
    
}
