package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Process representig a generic lamp
 *
 * Created on 12 May 2003, 11:29
 * @author  Marcel Oliveira
 */
public class GenericLamp implements CSProcess {

    public class CSP implements CSProcess {
		/* Lamp status */
		private OnOff status;

		/* Schema InitGenericLamp */
		private void initGenericLamp() {
		    status = new OnOff(OnOff.OFF);
		}

		/* Switch the status of the lamp */
		public void switchLampStatus(OnOff status){
		    status = status;

		    /* GUI */
		    visualisation.switchLampStatus(status);
		}

		public void run() {
		    initGenericLamp();
		    
		    class I_0 implements CSProcess {
		        public OnOff aux_l_status_0;
		        public I_0(OnOff status){
		            this.aux_l_status_0 = status;
		        }
		        public void run(){
		            {
		                OnOff status = (OnOff)switchLamp[t.intValue()][id.getValue()].read();
		                switchLampStatus(status);
		                I_0 i_0_0 = new I_0(aux_l_status_0);
		                i_0_0.run();
		                aux_l_status_0 = i_0_0.aux_l_status_0;
		            }
		        }
		    }
		    I_0 i_0_0 = new I_0(status);
		    i_0_0.run();
		    status = i_0_0.aux_l_status_0;
		}
	}

	/* Generic */
    private Integer t;

    /* id */
    private Type id;
    
    /* Communication channel of this process */
    private ChannelInput[][] switchLamp;
    
    /* GUI */
    private GenericLampGui visualisation;

    /* Creates a new instance of GenericLamp */
    public GenericLamp(Integer newt, Type newId, ChannelInput[][] newSwitchLamp) {
        this.t = newt;
        this.id = newId;
        this.switchLamp = newSwitchLamp;

        /* GUI */
        this.visualisation = new GenericLampGui(this.id);
        this.visualisation.show();
    }
    
    /* runs this process */
    public void run() {
        CSP csp = new CSP();
        csp.run();
    }
    
}
