package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;


/*
 * Process representig a display controller
 *
 * Created on 12 May 2003, 11:29
 * @author  Marcel Oliveira
 */
public class DisplayController implements CSProcess {
    class ParBranch_0 implements CSProcess {
        public ParBranch_0() {}
        public void run(){
            switchBuzzer.write(new OnOff(OnOff.OFF));
        }
    }
    class ParBranch_1 implements CSProcess {
        public ParBranch_1() {}
        public void run(){
            switchLamp[Type.LAMP_ID][LampId.ZONE_FAULT_LAMP].write(new OnOff(OnOff.OFF));
        }
    }
    class ParBranch_2 implements CSProcess {
        public ParBranch_2() {}
        public void run(){
            switchLamp[Type.LAMP_ID][LampId.EARTH_FAULT_LAMP].write(new OnOff(OnOff.OFF));
        }
    }
    class ParBranch_3 implements CSProcess {
        public ParBranch_3() {}
        public void run(){
            switchLamp[Type.LAMP_ID][LampId.SOUNDER_LINE_FAULT_LAMP].write(new OnOff(OnOff.OFF));
        }
    }
    class ParBranch_4 implements CSProcess {
        public ParBranch_4() {}
        public void run(){
            switchLamp[Type.LAMP_ID][LampId.POWER_FAULT_LAMP].write(new OnOff(OnOff.OFF));
        }
    }
    class ParBranch_5 implements CSProcess {
        public ParBranch_5() {}
        public void run(){
            switchLamp[Type.LAMP_ID][LampId.ISOLATE_REMOTE_SIGNAL_LAMP].write(new OnOff(OnOff.OFF));
        }
    }
    class ParBranch_6 implements CSProcess {
        public ParBranch_6() {}
        public void run(){
            switchLamp[Type.LAMP_ID][LampId.ACTUATOR_LINE_FAULT_LAMP].write(new OnOff(OnOff.OFF));
        }
    }
    class ParBranch_7 implements CSProcess {
        public ParBranch_7() {}
        public void run(){
            switchLamp[Type.LAMP_ID][LampId.ALARM_SILENCED_LAMP].write(new OnOff(OnOff.OFF));
        }
    }
    class ParBranch_8 implements CSProcess {
        public ParBranch_8() {}
        public void run(){
            switchLamp[Type.ZONE_ID][ZoneId.Z_0].write(new OnOff(OnOff.OFF));
        }
    }
    class ParBranch_9 implements CSProcess {
        public ParBranch_9() {}
        public void run(){
            switchLamp[Type.ZONE_ID][ZoneId.Z_1].write(new OnOff(OnOff.OFF));
        }
    }

    class ParBranch_10 implements CSProcess {
        public ParBranch_10() {}
        public void run(){
            switchLamp[Type.ZONE_ID][ZoneId.Z_2].write(new OnOff(OnOff.OFF));
        }
    }

    class ParBranch_11 implements CSProcess {
        public ParBranch_11() {}
        public void run(){
            switchLamp[Type.ZONE_ID][ZoneId.Z_3].write(new OnOff(OnOff.OFF));
        }
    }

    class ParBranch_12 implements CSProcess {
        public ParBranch_12() {}
        public void run(){
            switchLamp[Type.ZONE_ID][ZoneId.Z_4].write(new OnOff(OnOff.OFF));
        }
    }

    class ParBranch_13 implements CSProcess {
        public ParBranch_13() {}
        public void run(){
            switchLamp[Type.ZONE_ID][ZoneId.Z_5].write(new OnOff(OnOff.OFF));
        }
    }
    
    class ParBranch_14 implements CSProcess {
        public ParBranch_14() {}
        public void run(){
            switchLamp[Type.AREA_ID][AreaId.A_0].write(new OnOff(OnOff.OFF));
        }
    }

    class ParBranch_15 implements CSProcess {
        public ParBranch_15() {}
        public void run(){
            switchLamp[Type.AREA_ID][AreaId.A_1].write(new OnOff(OnOff.OFF));
        }
    }

    public class CSP implements CSProcess {
		/* InitDisplay Action */
		private void startDisplay() {

		    // Wait a multi-sinchronisation on channel switchOn
		    Vector seqOfSync = new Vector();
		    Object[] sync = new Object[]{from_switchOn[DISPLAY_CONTROLLER_SYNC_ID.intValue()], to_switchOn, DISPLAY_CONTROLLER_SYNC_ID, KEYBOARD_SYNC_ID};
		    seqOfSync.addElement(sync);
		    MultiSyncClient client = new MultiSyncClient(seqOfSync,new Vector(), null);
		    client.run();

		    switchLamp[Type.LAMP_ID][LampId.SYSTEM_ON_LAMP].write(new OnOff(OnOff.ON));
		    switched.write(null);
		    displayCycle();
		}

		/* SwitchLampsOff Action */
		private void switchLampsOff() {
		    /*
		     * THIS PART OF THE TRANSLATION WAS SLIGHTLY CHANGED FROM THE STRATEGY!!!
		     * INSTEAD OF NESTING PROCESSES IN INTERLEAVING, I WILL CREATE
		     * ONLY ONE PARALLELISM ON THE END. THIS IS OK BECAUSE THERE IS NO LOCAL
		     * VARIABLE, AND NO STATE COMPONENT IN THIS PROCESS. THOUGH, IT IS NOT 
		     * NEEDED TO MAKE ANY PARTITION; THEREFORE, IT IS NOT NEEDED TO TO IT AS IN
		     * THE TRANSLATION STRATEGY.
		     *
		     * INSTEAD OF NAMING THE CLASSES ParLBranch_0 AND ParRBranch_0, I WILL
		     * NAMING THEM ParBranch_i
		     */
		    CSProcess p_0 = new ParBranch_0();
		    
		    CSProcess p_1 = new ParBranch_1();

		    CSProcess p_2 = new ParBranch_2();

		    CSProcess p_3 = new ParBranch_3();

		    CSProcess p_4 = new ParBranch_4();

		    CSProcess p_5 = new ParBranch_5();

		    CSProcess p_6 = new ParBranch_6();

		    CSProcess p_7 = new ParBranch_7();

		    CSProcess p_8 = new ParBranch_8();

		    CSProcess p_9 = new ParBranch_9();

		    CSProcess p_10 = new ParBranch_10();

		    CSProcess p_11 = new ParBranch_11();

		    CSProcess p_12 = new ParBranch_12();

		    CSProcess p_13 = new ParBranch_13();
		    
		    CSProcess p_14 = new ParBranch_14();

		    CSProcess p_15 = new ParBranch_15();

		    CSProcess[] procs_0 = new CSProcess[]{p_0,p_1,p_2,p_3,p_4,p_5,p_6,p_7,p_8,p_9,p_10,
		                                            p_11,p_12,p_13,p_14,p_15};
		    (new Parallel(procs_0)).run();    
		}

		/* runs this process */
		private void displayCycle() {
		    final int RESET              = 0;
		    final int DETECTION          = 1;
		    final int ACTUATORS_REPLACED = 2;
		    final int SILENCE_ALARM      = 3;
		    final int FAULT              = 4;
		    final int DISPLAY_DISCHARGE  = 5;

		    // Wait a multi-sinchronisation on the given channel
		    Vector seqOfSync = new Vector();
		    Object[] sync = new Object[]{from_reset[DISPLAY_CONTROLLER_SYNC_ID.intValue()], to_reset, DISPLAY_CONTROLLER_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync2 = new Object[]{from_detection[DISPLAY_CONTROLLER_SYNC_ID.intValue()], to_detection, DISPLAY_CONTROLLER_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync3 = new Object[]{from_actuatorsReplaced[DISPLAY_CONTROLLER_SYNC_ID.intValue()], to_actuatorsReplaced, DISPLAY_CONTROLLER_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync4 = new Object[]{from_silenceAlarm[DISPLAY_CONTROLLER_SYNC_ID.intValue()], to_silenceAlarm, DISPLAY_CONTROLLER_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync5 = new Object[]{from_fault[DISPLAY_CONTROLLER_SYNC_ID.intValue()], to_fault, DISPLAY_CONTROLLER_SYNC_ID, KEYBOARD_SYNC_ID};
		    seqOfSync.addElement(sync);
		    seqOfSync.addElement(sync2);
		    seqOfSync.addElement(sync3);
		    seqOfSync.addElement(sync4);
		    seqOfSync.addElement(sync5);

		    Vector seqOfNotSync = new Vector();
		    seqOfNotSync.addElement(displayDischarge);
		    MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, null);
		    client.run();

		    switch(client.getChoosen()) {
		        case RESET:
		            switchLampsOff();
		            switched.write(null);
		            displayCycle();
		            break;
		        case DETECTION:
		            {
		                ZoneId zone = (ZoneId)client.getValueTrans();
		                switchLamp[Type.ZONE_ID][zone.getValue()].write(new OnOff(OnOff.ON));
		                switched.write(null);
		                displayCycle();
		            }
		            break;
		        case ACTUATORS_REPLACED:
		            switchLamp[Type.LAMP_ID][LampId.CIRCUIT_FAULT_LAMP].write(new OnOff(OnOff.OFF));
		            switched.write(null);
		            displayCycle();
		            break;
		        case SILENCE_ALARM:
		            switchLamp[Type.LAMP_ID][LampId.ALARM_SILENCED_LAMP].write(new OnOff(OnOff.ON));
		            switched.write(null);
		            displayCycle();
		            break;
		        case FAULT:
		            {
		                FaultId faultId = (FaultId)client.getValueTrans();
		                switchLamp[Type.LAMP_ID][AxiomaticDefinitions.getLampId(faultId).getValue()].write(new OnOff(OnOff.ON));
		                switchBuzzer.write(new OnOff(OnOff.ON));
		                switched.write(null);
		                displayCycle();
		            }
		            break;
		        case DISPLAY_DISCHARGE:
		            {
		                SetOfType areas = (SetOfType)client.getValueTrans();

		                Vector procVec_0 = new Vector();
		                class I_0 implements CSProcess {
		                    AreaId area;
		                    public I_0(AreaId newarea) {
		                        this.area = newarea;
		                    }
		                    public void run() {
		                        switchLamp[Type.AREA_ID][area.getValue()].write(new OnOff(OnOff.ON));
		                    }
		                }
		                
		                for (int area=0; area<areas.size(); area++){ 
		                    procVec_0.add(new I_0((AreaId)areas.getElement(area)));
		                }

		                for (int i=0; i<procVec_0.size(); i++) {
		                    ((CSProcess)procVec_0.elementAt(i)).run();
		                }

		                switchLamp[Type.LAMP_ID][LampId.CIRCUIT_FAULT_LAMP].write(new OnOff(OnOff.ON));
		                switched.write(null);
		                displayCycle();
		            }
		            break;
		    } 
		}

		public void run() {
		    startDisplay();
		}
	}

	/* switchOn channel */
    private AltingChannelInput[] from_switchOn;
    private ChannelOutput to_switchOn;

    /* detection channel */
    private AltingChannelInput[] from_detection;
    private ChannelOutput to_detection;
    
    /* fault channel */
    private AltingChannelInput[] from_fault;
    private ChannelOutput to_fault;

    /* silenceAlarm channel */
    private AltingChannelInput[] from_silenceAlarm;
    private ChannelOutput to_silenceAlarm;
    
    /* reset channel */
    private AltingChannelInput[] from_reset;
    private ChannelOutput to_reset;
    
    /* actuators replaced channel */
    private AltingChannelInput[] from_actuatorsReplaced;
    private ChannelOutput to_actuatorsReplaced;
    
    /* displayDischarge channel */
    private ChannelOutput displayDischarge;

    /* switched channel */
    private ChannelOutput switched;

    /* switchLamp channels */
    private ChannelOutput[][] switchLamp;
    
    /* switchBuzzer channel */
    private ChannelOutput switchBuzzer;

    /* Synchronisations IDs */
    final Integer KEYBOARD_SYNC_ID = new Integer(Integer.parseInt(Config.getInstance().getMessage("KEYBOARD_SYNC_ID")));
    final Integer DISPLAY_CONTROLLER_SYNC_ID = new Integer(Integer.parseInt(Config.getInstance().getMessage("DISPLAY_CONTROLLER_SYNC_ID")));

    /* Creates a new instance of DisplayController */
    public DisplayController(AltingChannelInput[] newfrom_switchOn, ChannelOutput newto_switchOn,
                            AltingChannelInput[] newfrom_detection, ChannelOutput newto_detection,
                            AltingChannelInput[] newfrom_fault, ChannelOutput newto_fault,
                            AltingChannelInput[] newfrom_silenceAlarm, ChannelOutput newto_silenceAlarm,
                            AltingChannelInput[] newfrom_reset, ChannelOutput newto_reset,
                            AltingChannelInput[] newfrom_actuatorsReplaced, 
                            ChannelOutput newto_actuatorsReplaced,
                            ChannelOutput newdisplayDischarge, 
                            ChannelOutput newswitched, 
                            ChannelOutput[][] newswitchLamp, 
                            ChannelOutput newswitchBuzzer) {
        this.from_switchOn = newfrom_switchOn;
        this.to_switchOn = newto_switchOn;
        this.from_detection = newfrom_detection;
        this.to_detection = newto_detection;
        this.from_fault = newfrom_fault;
        this.to_fault = newto_fault;
        this.from_silenceAlarm = newfrom_silenceAlarm;
        this.to_silenceAlarm = newto_silenceAlarm;
        this.from_reset = newfrom_reset;
        this.to_reset = newto_reset;
        this.from_actuatorsReplaced = newfrom_actuatorsReplaced;
        this.to_actuatorsReplaced = newto_actuatorsReplaced;
        this.displayDischarge = newdisplayDischarge;
        this.switched = newswitched;
        this.switchLamp = newswitchLamp;
        this.switchBuzzer = newswitchBuzzer;
    }
    
    /* runs this process */
    public void run() {
        CSP csp = new CSP();
        csp.run();
        
    }

}
