package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Process representig the display buzzer
 *
 * Created on 13 May 2003, 13:21
 * @author  Marcel Oliveira
 */
public class DisplayBuzzer implements CSProcess {
	private OnOff status;

	/* Initialises the process */
	private void initDisplayBuzzer() {
	    status = new OnOff(OnOff.OFF);
	}

	/* Switch the status of the display buzzer */
	private void switchDisplayBuzzerStatus(OnOff newStatus){
	    status = newStatus;

	    /* GUI */
	    BuzzerSound.setStatus(newStatus);
	}
    class I_0 implements CSProcess {
        public OnOff aux_l_status_0;
        public I_0(OnOff status){
            this.aux_l_status_0 = status;
        }
        public void run(){
            {
                OnOff status = (OnOff)switchBuzzer.read();
                switchDisplayBuzzerStatus(status);
                I_0 i_0_0 = new I_0(aux_l_status_0);
                i_0_0.run();
                aux_l_status_0 = i_0_0.aux_l_status_0;
            }
        }
    }

    public class CSP implements CSProcess {
		/* Buzzer status */
		public void run(){
		    initDisplayBuzzer();
		    I_0 i_0_0 = new I_0(status);
		    i_0_0.run();
		    status = i_0_0.aux_l_status_0;
		}
	}

	/* Communication channel of this process */
    private ChannelInput switchBuzzer;

    /* Creates a new instance of DisplayBuzzer */
    public DisplayBuzzer(ChannelInput newswitchBuzzer) {
        this.switchBuzzer = newswitchBuzzer;

        /* GUI */
        Thread buzzerSound = new Thread(BuzzerSound.getInstance(1000));
        buzzerSound.start();
    }
    
    /* runs this process */
    public void run() {
        CSP csp = new CSP();
        csp.run();
    }
    
}
