package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Classe que representa o processo DisplayLamps
 *
 * Created on 13 May 2003, 12:53
 * @author  Marcel Oliveira
 */
public class Display implements CSProcess {
	public class CSP3 implements CSProcess {
		public void run() {
			//db
		    DisplayBuzzer db = new DisplayBuzzer(switchBuzzer);
		    db.run();
		}
	}

	public class CSP2 implements CSProcess {
		public void run() {
			//dl
		    DisplayLamps dl = new DisplayLamps(switchLamp);
		    dl.run();
		}
	}

    public class CSP1 implements CSProcess {
		public void run(){
			CSProcess [] cspVetor1 = new CSProcess [] {
		            (new CSP2()),
		            (new CSP3())					
			};
		    Parallel emParalelo1 = new Parallel(cspVetor1);
		    emParalelo1.run();
		}
	}

	private ChannelInput[][] switchLamp;
    private ChannelInput switchBuzzer;
    
    /* Creates a new instance of DisplayLamps */
    public Display(ChannelInput[][] newswitchLamp, ChannelInput newswitchBuzzer) {
        this.switchLamp = newswitchLamp;
        this.switchBuzzer = newswitchBuzzer;
    }
    
    /* runs this process */
    public void run() {
        CSP1 csp1 = new CSP1();
        csp1.run();
    }
 
}
