package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Process FireControlSystem
 *
 * Created on 22 May 2003, 19:15
 * @author  Marcel Oliveira
 */
public class ConcreteFireControl implements CSProcess {
    CSP1 csp1;
    CSP2 csp2;
    CSP3 csp3;
    CSP4 csp4;
    CSP5 csp5;
    CSP6 csp6;
    CSP7 csp7;
    CSP8 csp8;
    CSP9 csp9;
    CSP10 csp10;
    CSP11 csp11;
    CSP12 csp12;

	private Any2OneChannel endManager;

	public ConcreteFireControl(AltingChannelInput[] newfrom_switchOn, ChannelOutput newto_switchOn, 
			AltingChannelInput[] newfrom_detection, ChannelOutput newto_detection, 
			AltingChannelInput[] newfrom_silenceAlarm, ChannelOutput newto_silenceAlarm, 
			AltingChannelInput[] newfrom_reset, ChannelOutput newto_reset, 
			AltingChannelInput[] newfrom_actuatorsReplaced, ChannelOutput newto_actuatorsReplaced, 
			AltingChannelInput[] newfrom_modeSwitch, ChannelOutput newto_modeSwitch, 
			AltingChannelInput newexternalManualDischarge, 
			AltingChannelInput[] newfrom_fault, ChannelOutput newto_fault, 
			ChannelOutput newalarm, 
			ChannelOutput[][] newswitchLamp, 
			ChannelOutput newswitchBuzzer, ChannelOutput newsystemState,
			AltingChannelInput newclockFinished, ChannelOutput newstartClock) {

		csp1 = new CSP1(endManager);
		csp2 = new CSP2 ();
		csp3 = new CSP3 ();
		csp4 = new CSP4 ();
		csp5 = new CSP5 ();
		csp6 = new CSP6 ();
		csp7 = new CSP7 ();
		csp8 = new CSP8 ();
		csp9 = new CSP9 ();
		csp10 = new CSP10 ();
		csp11 = new CSP11 ();
		csp12 = new CSP12 ();
		
		this.from_switchOn = newfrom_switchOn; 
		this.to_switchOn = newto_switchOn;
		this.from_detection = newfrom_detection;
		this.to_detection = newto_detection;
		this.from_silenceAlarm = newfrom_silenceAlarm;
		this.to_silenceAlarm = newto_silenceAlarm;
		this.from_reset = newfrom_reset;
		this.to_reset = newto_reset; 
		this.from_actuatorsReplaced = newfrom_actuatorsReplaced; 
		this.to_actuatorsReplaced = newto_actuatorsReplaced; 
		this.from_modeSwitch = newfrom_modeSwitch; 
		this.to_modeSwitch = newto_modeSwitch;
		this.externalManualDischarge = newexternalManualDischarge; 
		this.from_fault = newfrom_fault;
		this.to_fault = newto_fault;
		this.alarm = newalarm;
		this.switchLamp = newswitchLamp;
		this.switchBuzzer = newswitchBuzzer;
		this.systemState = newsystemState;
		this.clockFinished = newclockFinished;
		this.startClock = newstartClock;

		// Hidden Channels
		this.countdown = new Any2OneChannel();

		this.gasDischarged = Any2OneChannel.create(AreaId.MAX_AREA_ID - AreaId.MIN_AREA_ID + 1);
		this.gasNotDischarged = Any2OneChannel.create(AreaId.MAX_AREA_ID - AreaId.MIN_AREA_ID + 1);

		this.from_manualDischarge = Any2OneChannel.create(1+AreaId.MAX_AREA_ID - AreaId.MIN_AREA_ID + 1);
		this.to_manualDischarge = new Any2OneChannel();

		this.from_automaticDischarge = Any2OneChannel.create(1+AreaId.MAX_AREA_ID - AreaId.MIN_AREA_ID + 1);
		this.to_automaticDischarge = new Any2OneChannel();

		this.from_counting = Any2OneChannel.create(1+AreaId.MAX_AREA_ID - AreaId.MIN_AREA_ID + 1);
		this.to_counting = new Any2OneChannel();

		this.from_anyDischarge = Any2OneChannel.create(1+AreaId.MAX_AREA_ID - AreaId.MIN_AREA_ID + 1);
		this.to_anyDischarge = new Any2OneChannel();

		this.from_noDischarge = Any2OneChannel.create(1+AreaId.MAX_AREA_ID - AreaId.MIN_AREA_ID + 1);
		this.to_noDischarge = new Any2OneChannel();
	}

	public class CSP12 implements CSProcess {
		public void run() {
		    //(new MultiSyncControl(10,1+AreaId.MAX_AREA_ID - AreaId.MIN_AREA_ID + 1,from_noDischarge, to_noDischarge)).run();
		    (new MultiSyncControl(from_noDischarge, to_noDischarge)).run();
		}
	}
	public class CSP11 implements CSProcess {
		public void run() {
		    //(new MultiSyncControl(9,1+AreaId.MAX_AREA_ID - AreaId.MIN_AREA_ID + 1,from_anyDischarge, to_anyDischarge)).run();
		    (new MultiSyncControl(from_anyDischarge, to_anyDischarge)).run();
		}
	}
	public class CSP10 implements CSProcess {
		public void run() {
		    //(new MultiSyncControl(8,1+AreaId.MAX_AREA_ID - AreaId.MIN_AREA_ID + 1,from_counting, to_counting)).run();
		    (new MultiSyncControl(from_counting, to_counting)).run();
		}
	}

	public class CSP9 implements CSProcess {
		public void run() {
		    //(new MultiSyncControl(7,1+AreaId.MAX_AREA_ID - AreaId.MIN_AREA_ID + 1,from_automaticDischarge, to_automaticDischarge)).run();
		    (new MultiSyncControl(from_automaticDischarge, to_automaticDischarge)).run();
		}
	}

	public class CSP8 implements CSProcess {
		public void run() {
		    (new MultiSyncControl(from_manualDischarge, to_manualDischarge)).run();
		}
	}
	public class CSP7 implements CSProcess {
		public void run(){
			CSProcess [] cspvetor3 = new CSProcess [] {csp8, csp9, csp10, csp11, csp12};
			Parallel emParalelo3 = new Parallel (cspvetor3);
			emParalelo3.run();
		}
	}
	public class CSP6 implements CSProcess {
		public void run(){
			ControllersManager cmanagers = new ControllersManager (endManager, csp7);
			cmanagers.run();
		}
	}
	public class CSP5 implements CSProcess {
		public void run() {
			ConcreteInternalSystem concreteInternalSystem = new ConcreteInternalSystem (from_switchOn, to_switchOn,
                    from_detection, to_detection,
                    from_silenceAlarm, to_silenceAlarm, 
                    from_reset, to_reset,
                    from_actuatorsReplaced, to_actuatorsReplaced,
                    from_modeSwitch, to_modeSwitch,
                    externalManualDischarge,
                    countdown, 
                    from_fault, to_fault,
                    gasDischarged,
                    gasNotDischarged, 
                    from_manualDischarge, to_manualDischarge,
                    from_automaticDischarge, to_automaticDischarge,
                    from_counting, to_counting,
                    from_anyDischarge, to_anyDischarge,
                    from_noDischarge, to_noDischarge,
                    alarm,
                    switchLamp, switchBuzzer,
                    systemState,
                    clockFinished, startClock);
			concreteInternalSystem.run();
		}
	}

	public final class CSP4 implements CSProcess {
		public void run() {
			ConcreteAreas concreteAreas = new ConcreteAreas (from_switchOn, to_switchOn,
                    from_detection, to_detection,
                    from_reset, to_reset,
                    from_actuatorsReplaced, to_actuatorsReplaced,
                    from_silenceAlarm, to_silenceAlarm,
                    from_modeSwitch, to_modeSwitch,
                    countdown, 
                    gasDischarged, 
                    gasNotDischarged,
                    from_manualDischarge, to_manualDischarge,
                    from_automaticDischarge, to_automaticDischarge,
                    from_counting, to_counting,
                    from_anyDischarge, to_anyDischarge,
                    from_noDischarge, to_noDischarge);
			concreteAreas.run();
		}
	}
	public class CSP3 implements CSProcess {
		CSProcess [] cspVetor2 = new CSProcess [] {csp4, csp5};
		Parallel emParalelo2 = new Parallel (cspVetor2);
		public void run(){ //run de CSP3
			emParalelo2.run();
		}
	}
	public class CSP2 implements CSProcess {
		public void run(){ //run de CSP2
			ProcessManagerMultiSync pmms1 = new ProcessManagerMultiSync (endManager, new CSP3());
			pmms1.run();
		}
	}

    public class CSP1 implements CSProcess {
		public CSP1(Any2OneChannel _endManager) {
			endManager = _endManager;
		}

		public void run(){ //declarao run de CSP1
			CSProcess [] cspvetor1 = new CSProcess [] {csp2, csp6};
			Parallel emParalelo1 = new Parallel (cspvetor1);
			emParalelo1.run();
//		    (new Parallel( //Instanciar: Parallel emParalelo1 = new Parallel (instancia de CSP2);
//		        new CSProcess[] { //Classe CSPVetor1 (vetor)
//		            csp2,
//		            csp6
//		        }
//		    )).run();
		}
	}


	private AltingChannelInput[] from_switchOn; 
    private ChannelOutput to_switchOn;
    private AltingChannelInput[] from_detection;
    private ChannelOutput to_detection;
    private AltingChannelInput[] from_silenceAlarm;
    private ChannelOutput to_silenceAlarm;
    private AltingChannelInput[] from_reset;
    private ChannelOutput to_reset; 
    private AltingChannelInput[] from_actuatorsReplaced; 
    private ChannelOutput to_actuatorsReplaced; 
    private AltingChannelInput[] from_modeSwitch; 
    private ChannelOutput to_modeSwitch;
    private AltingChannelInput externalManualDischarge; 
    private AltingChannelInput[] from_fault;
    private ChannelOutput to_fault;
    private ChannelOutput alarm;
    private ChannelOutput[][] switchLamp;
    private ChannelOutput switchBuzzer;
    private ChannelOutput systemState;
    private AltingChannelInput clockFinished;
    private ChannelOutput startClock;

    private Any2OneChannel countdown;
    private Any2OneChannel[] gasDischarged;
    private Any2OneChannel[] gasNotDischarged;
    private Any2OneChannel[] from_manualDischarge;
    private Any2OneChannel to_manualDischarge;
    private Any2OneChannel[] from_automaticDischarge;
    private Any2OneChannel to_automaticDischarge;
    private Any2OneChannel[] from_counting;
    private Any2OneChannel to_counting;
    private Any2OneChannel[] from_anyDischarge;
    private Any2OneChannel to_anyDischarge;
    private Any2OneChannel[] from_noDischarge;
    private Any2OneChannel to_noDischarge;

    /* Creates a new instance of FireControlSystem */
    
    public void run() {
        final Any2OneChannel endManager = new Any2OneChannel();
        csp1 = new CSP1(endManager);
        csp1.run();
    }
}
