package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Classe que representa o processo Areas
 *
 * Created on 22 May 2003, 14:00
 * @author  Marcel Oliveira
 */
public class ConcreteAreas implements CSProcess {

    private AltingChannelInput[] from_switchOn;
    private ChannelOutput to_switchOn;
    private AltingChannelInput[] from_detection;
    private ChannelOutput to_detection;
    private AltingChannelInput[] from_reset;
    private ChannelOutput to_reset;
    private AltingChannelInput[] from_actuatorsReplaced;
    private ChannelOutput to_actuatorsReplaced;
    private AltingChannelInput[] from_silenceAlarm;
    private ChannelOutput to_silenceAlarm;
    private AltingChannelInput[] from_modeSwitch;
    private ChannelOutput to_modeSwitch;
    private ChannelOutput countdown;
    private ChannelOutput[] gasDischarged;
    private ChannelOutput[] gasNotDischarged;
    private AltingChannelInput[] from_manualDischarge;
    private ChannelOutput to_manualDischarge;
    private AltingChannelInput[] from_automaticDischarge;
    private ChannelOutput to_automaticDischarge;
    private AltingChannelInput[] from_counting;
    private ChannelOutput to_counting;
    private AltingChannelInput[] from_anyDischarge; 
    private ChannelOutput to_anyDischarge;
    private AltingChannelInput[] from_noDischarge; 
    private ChannelOutput to_noDischarge;

    /* Creates a new instance of Areas */
    public ConcreteAreas(AltingChannelInput[] newfrom_switchOn, ChannelOutput newto_switchOn, 
                            AltingChannelInput[] newfrom_detection, ChannelOutput newto_detection, 
                            AltingChannelInput[] newfrom_reset, ChannelOutput newto_reset, 
                            AltingChannelInput[] newfrom_actuatorsReplaced, 
                            ChannelOutput newto_actuatorsReplaced, 
                            AltingChannelInput[] newfrom_silenceAlarm, 
                            ChannelOutput newto_silenceAlarm, 
                            AltingChannelInput[] newfrom_modeSwitch, ChannelOutput newto_modeSwitch, 
                            ChannelOutput newcountdown, 
                            ChannelOutput[] newgasDischarged, ChannelOutput[] newgasNotDischarged, 
                            AltingChannelInput[] newfrom_manualDischarge,
                            ChannelOutput newto_manualDischarge, 
                            AltingChannelInput[] newfrom_automaticDischarge, 
                            ChannelOutput newto_automaticDischarge, 
                            AltingChannelInput[] newfrom_counting, ChannelOutput newto_counting, 
                            AltingChannelInput[] newfrom_anyDischarge, ChannelOutput newto_anyDischarge, 
                            AltingChannelInput[] newfrom_noDischarge, ChannelOutput newto_noDischarge) {

        this.from_switchOn = newfrom_switchOn;
        this.to_switchOn = newto_switchOn;
        this.from_detection = newfrom_detection;
        this.to_detection = newto_detection;
        this.from_reset = newfrom_reset;
        this.to_reset = newto_reset;
        this.from_actuatorsReplaced = newfrom_actuatorsReplaced;
        this.to_actuatorsReplaced = newto_actuatorsReplaced;
        this.from_silenceAlarm = newfrom_silenceAlarm;
        this.to_silenceAlarm = newto_silenceAlarm;
        this.from_modeSwitch = newfrom_modeSwitch;
        this.to_modeSwitch = newto_modeSwitch;
        this.countdown = newcountdown;
        this.gasDischarged = newgasDischarged;
        this.gasNotDischarged = newgasNotDischarged;
        this.from_manualDischarge = newfrom_manualDischarge;
        this.to_manualDischarge = newto_manualDischarge;
        this.from_automaticDischarge = newfrom_automaticDischarge;
        this.to_automaticDischarge = newto_automaticDischarge;
        this.from_counting = newfrom_counting;
        this.to_counting = newto_counting;
        this.from_anyDischarge = newfrom_anyDischarge;
        this.to_anyDischarge = newto_anyDischarge;
        this.from_noDischarge = newfrom_noDischarge;
        this.to_noDischarge = newto_noDischarge;
                    
    }
    
    public class I_0 implements CSProcess { //Classe I_0
        public AreaId id;
        public I_0 (AreaId newid){
            this.id = newid;
        }                    
        public void run(){ //run de I_0
            CspConcreteAreas2 cspcareas2 = new CspConcreteAreas2 (this.id);
            cspcareas2.run();
        }
    }
    public class CspConcreteAreas1 implements CSProcess {
                public void run(){ //run de CspConcreteAreas1
                    Vector procVec_0 = new Vector();
        //Botar separado a classe abaixo
                    /*class I_0 implements CSProcess { //Classe I_0
                        private AreaId id;

                        public I_0 (AreaId newid){
                            this.id = newid;
                        }                    
                        public void run(){ //run de I_0
                        	
                        //Botar separado a classe abaixo
                        	
                            (new CSProcess(){ //Classe CspConcreteAreas2
                                public void run(){ //run de CspConcreteAreas2
                                	Area area = new Area (id, 
                                            from_switchOn, to_switchOn,
                                            from_detection, to_detection,
                                            from_reset, to_reset,
                                            from_actuatorsReplaced, to_actuatorsReplaced,
                                            from_silenceAlarm, to_silenceAlarm,
                                            from_modeSwitch, to_modeSwitch,
                                            countdown, 
                                            gasDischarged, 
                                            gasNotDischarged,
                                            from_manualDischarge, to_manualDischarge,
                                            from_automaticDischarge, to_automaticDischarge,
                                            from_counting, to_counting,
                                            from_anyDischarge, to_anyDischarge,
                                            from_noDischarge, to_noDischarge);
                                    area.run();
                                }
                            }).run();
                        }
                        //Botar separado a classe acima
                    } */
        //Botar separado a classe acima
                    for (AreaId id = new AreaId(AreaId.MIN_AREA_ID); 
                            id.compareTo(new AreaId(AreaId.MAX_AREA_ID)) <= 0; id=new AreaId(id.getValue()+1) ) {
                        procVec_0.add(new I_0(id));
                    }

                    CSProcess[] processes_0 = new CSProcess[procVec_0.size()];

                    for (int i=0; i < procVec_0.size(); i++) {
                        processes_0[i] = (CSProcess)procVec_0.get(i);
                    }
                    Parallel emParalelo = new Parallel (processes_0);
                    emParalelo.run();
                }
    }
    public class CspConcreteAreas2 implements CSProcess {
    	public AreaId id;
    	public CspConcreteAreas2 (AreaId id) {
    		this.id = id;
    	}
        public void run(){ //run de CspConcreteAreas2
        	Area area = new Area (id, 
                    from_switchOn, to_switchOn,
                    from_detection, to_detection,
                    from_reset, to_reset,
                    from_actuatorsReplaced, to_actuatorsReplaced,
                    from_silenceAlarm, to_silenceAlarm,
                    from_modeSwitch, to_modeSwitch,
                    countdown, 
                    gasDischarged, 
                    gasNotDischarged,
                    from_manualDischarge, to_manualDischarge,
                    from_automaticDischarge, to_automaticDischarge,
                    from_counting, to_counting,
                    from_anyDischarge, to_anyDischarge,
                    from_noDischarge, to_noDischarge);
            area.run();
        }
    }
    /* runs this process */
    public void run() { //run de ConcreteAreas
    	CspConcreteAreas1 cspcareas1 = new CspConcreteAreas1 ();
    	cspcareas1.run();
/*        (new CSProcess() { //Classe CspConcreteAreas1
            public void run(){ //run de CspConcreteAreas1
                Vector procVec_0 = new Vector();
    //Botar separado a classe abaixo
                class I_0 implements CSProcess { //Classe I_0
                    private AreaId id;

                    public I_0 (AreaId newid){
                        this.id = newid;
                    }                    
                    public void run(){ //run de I_0
                    	
                    //Botar separado a classe abaixo
                    	
                        (new CSProcess(){ //Classe CspConcreteAreas2
                            public void run(){ //run de CspConcreteAreas2
                            	Area area = new Area (id, 
                                        from_switchOn, to_switchOn,
                                        from_detection, to_detection,
                                        from_reset, to_reset,
                                        from_actuatorsReplaced, to_actuatorsReplaced,
                                        from_silenceAlarm, to_silenceAlarm,
                                        from_modeSwitch, to_modeSwitch,
                                        countdown, 
                                        gasDischarged, 
                                        gasNotDischarged,
                                        from_manualDischarge, to_manualDischarge,
                                        from_automaticDischarge, to_automaticDischarge,
                                        from_counting, to_counting,
                                        from_anyDischarge, to_anyDischarge,
                                        from_noDischarge, to_noDischarge);
                                area.run();
                            }
                        }).run();
                    }
                    //Botar separado a classe acima
                }
    //Botar separado a classe acima


                for (AreaId id = new AreaId(AreaId.MIN_AREA_ID); 
                        id.compareTo(new AreaId(AreaId.MAX_AREA_ID)) <= 0; id=new AreaId(id.getValue()+1) ) {
                    procVec_0.add(new I_0(id));
                }

                CSProcess[] processes_0 = new CSProcess[procVec_0.size()];

                for (int i=0; i < procVec_0.size(); i++) {
                    processes_0[i] = (CSProcess)procVec_0.get(i);
                }
                Parallel emParalelo = new Parallel (processes_0);
                emParalelo.run();
            }
        }).run();*/
    } 
}
