package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Process representig a Clock
 *
 * Created on 22 May 2003, 16:02
 * @author  Marcel Oliveira
 */
public class Clock implements CSProcess {
    
    /* Channel startClock */
    private ChannelInput startClock;

    /* Channel clockFinished */
    private ChannelOutput clockFinished;

    /* Visualisation of this clock */
    private ClockGui visualisation;

    /* Creates a new instance of Clock */
    public Clock(ChannelInput newstartClock, ChannelOutput newclockFinished){
        this.startClock = newstartClock;
        this.clockFinished = newclockFinished;
        
        /* GUI */
        this.visualisation = new ClockGui();
    }
    
    public class CspClock implements CSProcess {
        private void clockCycle(){
            startClock.read();

            /* GUI */
            visualisation.show();

            clockInstance(AxiomaticDefinitions.gasDelay());

            /* GUI */
            visualisation.dispose();

            clockCycle();
        }

        /* Action ClockInstance */
        public void clockInstance(int tocks) {
            /* GUI */
            visualisation.setTocks(tocks);

            if (tocks == 0) {
                clockFinished.write(null);
            } else if (tocks != 0) {
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                clockInstance(tocks-1);
            }
        }
        
        public void run() {
            clockCycle();
        }

    }
    /* runs this process */
    public void run() {
    	CspClock cspclock = new CspClock ();
    	cspclock.run();
    }
}
