package fireControlSystem.gui;

import java.awt.Toolkit;
import fireControlSystem.typing.*;

/*
 * Plays the Buzzer
 *
 * Created on 14 May 2003, 16:00
 * @author  Marcel Oliveira
 */
public class BuzzerSound implements Runnable {
    
    /* Delay between each beep */
    private long delay;
    
    /* Indicates the status of the buzzer */
    private static OnOff status;

    /* Classe's singleton */
    private static BuzzerSound buzzerSound;
    
    /* Constructor of the class */
    private BuzzerSound(long delay) {
        this.delay = delay;
        this.status = new OnOff(OnOff.OFF);
    }

    /* Returns an instance of this class */
    public static BuzzerSound getInstance(long delay) {
        if (buzzerSound == null) {
            buzzerSound = new BuzzerSound(delay);
        }
        return buzzerSound;
    }
    
    /* Sets the value of the variable status */
    public static void setStatus(OnOff newStatus){
        status = newStatus;
    }
    
    /* Runs this class */
    public void run() {
        while(true) {
            if (this.status.getValue() == OnOff.ON) {
                Toolkit.getDefaultToolkit().beep();
            }
            try{
                Thread.sleep(delay);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
   
}
