package fireControlSystem.gui;

import fireControlSystem.typing.*;
import fireControlSystem.util.*;

/*
 * Visual Alarm of the System
 *
 * Created on 23 May 2003, 15:04
 * @author  Marcel Oliveira
 */
public class AlarmGui extends javax.swing.JFrame {
    
    private final String TITLE = International.getInstance().getMessage("MSG_0013"); 
    private final String ALARM_OFF = International.getInstance().getMessage("MSG_0014"); 
    private final String FIRST_STAGE = International.getInstance().getMessage("MSG_0015"); 
    private final String SECOND_STAGE = International.getInstance().getMessage("MSG_0016"); 
    private final int LAMPS_SIZE_Y = Integer.parseInt(Config.getInstance().getMessage("GENERIC_LAMP_SIZE_Y"));
    private final int LAMPS_TYPES = Integer.parseInt(Config.getInstance().getMessage("LAMPS_TYPES"));
    private final int SIZE_X = Integer.parseInt(Config.getInstance().getMessage("ALARM_SIZE_X"));
    private final int SIZE_Y = Integer.parseInt(Config.getInstance().getMessage("ALARM_SIZE_Y"));
    
    /* Creates new form AlarmGui */
    public AlarmGui() {
        initComponents();
        
        this.setTitle(this.TITLE);
        this.jLabelStage.setText(this.ALARM_OFF);
        this.setSize(this.SIZE_X,this.SIZE_Y);
        this.setLocation(0,this.LAMPS_TYPES*this.LAMPS_SIZE_Y);
    }
    
    /* This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelStage = new javax.swing.JLabel();
        jProgressBarStage = new javax.swing.JProgressBar();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setEnabled(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jLabelStage.setText("Stage");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(20, 10, 10, 10);
        getContentPane().add(jLabelStage, gridBagConstraints);

        jProgressBarStage.setMaximum(2);
        jProgressBarStage.setMaximumSize(null);
        jProgressBarStage.setMinimumSize(null);
        jProgressBarStage.setPreferredSize(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 20, 10);
        getContentPane().add(jProgressBarStage, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    /* Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm
    
    /* Sets the stage of the alarm */
    public void switchStage(AlarmStage newStage) {
        int value = 0;
        String text = "";
        
        switch (newStage.getValue()) {
            case AlarmStage.ALARM_OFF:
                value = 0;
                text = this.ALARM_OFF;
                break;
            case AlarmStage.FIRST_STAGE:
                value = 1;
                text = this.FIRST_STAGE;
                break;
            case AlarmStage.SECOND_STAGE:
                value = 2;
                text = this.SECOND_STAGE;
                break;
        }
        this.jProgressBarStage.setValue(value);
        this.jLabelStage.setText(text);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabelStage;
    private javax.swing.JProgressBar jProgressBarStage;
    // End of variables declaration//GEN-END:variables
    
}
