package fireControlSystem.axiomaticDefinitions;

import fireControlSystem.typing.*;

/*
 * Axiomatic Definitions od the System
 *
 * Created on 16 May 2003, 10:18
 * @author  Marcel Oliveira
 */
public class AxiomaticDefinitions {
    
    /* Creates a new instance of AxiomaticDefinitions */
    public AxiomaticDefinitions() {
    }
    
    /* Axiomatic Definition. Given a FaultId, it returns the correspondent LampId */
    public static LampId getLampId(FaultId fault) {
        LampId lampId;
        
        int faultId = fault.getValue();
        switch(faultId){
            case FaultId.ZONE_FAULT:
                lampId = new LampId(LampId.ZONE_FAULT_LAMP);
                break;
            case FaultId.EARTH_FAULT:
                lampId = new LampId(LampId.EARTH_FAULT_LAMP);
                break;
            case FaultId.SOUNDER_LINE_FAULT:
                lampId = new LampId(LampId.SOUNDER_LINE_FAULT_LAMP);
                break;
            case FaultId.POWER_FAULT:
                lampId = new LampId(LampId.POWER_FAULT_LAMP);
                break;
            case FaultId.ISOLATE_REMOTE_SIGNAL:
                lampId = new LampId(LampId.ISOLATE_REMOTE_SIGNAL_LAMP);
                break;
            case FaultId.ACTUATOR_LINE_FAULT:
                lampId = new LampId(LampId.ACTUATOR_LINE_FAULT_LAMP);
                break;
            default:
                throw new RuntimeException(Thread.currentThread().getClass().getName());
        }
        return lampId;
    }
    
    /* Axiomatic Definition gasDelay*/
    public static Integer gasDelay() {
        return new Integer(30);
    }

    /* Axiomatic Definition. Return the set of zones controled by an area */
    public static SetOfType getZones(AreaId id) {
        SetOfType zones = new SetOfType();
        if (id.getValue() == AreaId.A_0) {
            zones.addElement(new ZoneId(ZoneId.Z_0));
            zones.addElement(new ZoneId(ZoneId.Z_1));
        } else if (id.getValue() == AreaId.A_1) {
            zones.addElement(new ZoneId(ZoneId.Z_2));
            zones.addElement(new ZoneId(ZoneId.Z_3));
        }
        
        return zones;
    }
    
}
