package jcsp.lang;

import java.io.Serializable;
import jcsp.util.ChannelDataStore;

// Referenced classes of package jcsp.lang:
//            AltingChannelInput, ProcessInterruptedError, Any2OneChannelX, ChannelOutput, 
//            Alternative


public class Any2OneChannel extends AltingChannelInput
	implements ChannelOutput, Serializable

{
	
	protected Object rwMonitor;
	private Object hold;
	private boolean empty;
	protected Alternative alt;
	protected final Object writeMonitor = new Object();

    public Any2OneChannel()
    {
        rwMonitor = new Object();
        empty = true;
    }

    public Object read()
    {
        Object obj1;
        synchronized(rwMonitor)
        {
            if(empty)
            {
                empty = false;
                try
                {
                    rwMonitor.wait();
                }
                catch(InterruptedException interruptedexception)
                {
                    throw new ProcessInterruptedError("*** Thrown from Any2OneChannel.read ()\n" + interruptedexception.toString());
                }
            } else
            {
                empty = true;
            }
            rwMonitor.notify();
            obj1 = hold;
        }
        return obj1;
    }

    public void write(Object obj)
    {
        synchronized(writeMonitor)
        {
            synchronized(rwMonitor)
            {
                hold = obj;
                if(empty)
                {
                    empty = false;
                    if(alt != null)
                        alt.schedule();
                } else
                {
                    empty = true;
                    rwMonitor.notify();
                }
                try
                {
                    rwMonitor.wait();
                }
                catch(InterruptedException interruptedexception)
                {
                    throw new ProcessInterruptedError("*** Thrown from Any2OneChannel.write (Object)\n" + interruptedexception.toString());
                }
            }
        }
    }

    boolean enable(Alternative alternative)
    {
        boolean flag1;
        synchronized(rwMonitor)
        {
            if(empty)
            {
                alt = alternative;
                boolean flag = false;
                return flag;
            }
            flag1 = true;
        }
        return flag1;
    }

    boolean disable()
    {
        boolean flag;
        synchronized(rwMonitor)
        {
            alt = null;
            flag = !empty;
        }
        return flag;
    }

    public boolean pending()
    {
        boolean flag;
        synchronized(rwMonitor)
        {
            flag = !empty;
        }
        return flag;
    }

    public static Any2OneChannel[] create(int i)
    {
        Any2OneChannel aany2onechannel[] = new Any2OneChannel[i];
        for(int j = 0; j < i; j++)
            aany2onechannel[j] = new Any2OneChannel();

        return aany2onechannel;
    }

    public static Any2OneChannel create(ChannelDataStore channeldatastore)
    {
        return new Any2OneChannelX(channeldatastore);
    }

    public static Any2OneChannel[] create(int i, ChannelDataStore channeldatastore)
    {
        Any2OneChannel aany2onechannel[] = new Any2OneChannel[i];
        for(int j = 0; j < i; j++)
            aany2onechannel[j] = new Any2OneChannelX(channeldatastore);

        return aany2onechannel;
    }

}
