package jcircus.util;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.Expr;

/**
 * ProcInfo.java
 *
 * Contains the information of a process definition.
 *
 * @author Angela Freitas
 */
public class ProcInfo {

    /** Process name */
    private String _processName;
    
    /** Process definition */
    private ProcessPara _processPara;
    
    /** Code resulting from the translation of the process definition */
    private String _code;
    
    /** Normalized variable declarations. That is, each VarDecl declares at most
        one variable */
    private List<VarDecl> _parameters;
    
    /** Code for the parameters */
    private List<String> _codeForActuals;
    
    /** Flag indicating if a main is to be created for the process or not. */
    private boolean _createMain;
    
    
    /**
     * Constructor.
     */
    public ProcInfo(String processName, ProcessPara processPara, String code,
            List<VarDecl> parameters, boolean createMain) {
        this._processName = processName;
        this._processPara = processPara;
        this._code = code;
        this._parameters = parameters;
        this._codeForActuals = new ArrayList();
        this._createMain = createMain;
    }
    
    /**
     * Getters
     */
    public String getProcessName() {
        return this._processName;
    }
    
    public ProcessPara getProcessPara() {
        return this._processPara;
    }

    public List<VarDecl> getParameters() {
        return this._parameters;
    }
    
    public List<String> getCodeForActuals() {
        return this._codeForActuals;
    }
    
    public boolean getCreateMain() {
        return this._createMain;
    }
    
    public String getCode() {
        return this._code;
    }

    /**
     * Setters
     */
    public void setCreateMain(boolean createMain) {
        this._createMain = createMain;
    }

    /**
     * Other methods.
     */
    public void addCodeForActuals(int position, String code) {
        this._codeForActuals.add(position, code);
    }
    
    public Expr getTypeOfParameter(int position) {
        return ((VarDecl) _parameters.get(position)).getExpr();
    }
    
}
